/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

final class ObjectInputStreamWithClassloader
extends ObjectInputStream {
    private final ClassLoader loader;

    public ObjectInputStreamWithClassloader(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.loader = loader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), false, this.loader);
        }
        catch (ClassNotFoundException ex) {
            Class<?> cl = super.resolveClass(desc);
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }
}

