/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;

public class AMQPMessageReader
implements MessageReader {
    private final ProtonAbstractReceiver serverReceiver;
    private DeliveryAnnotations deliveryAnnotations;
    private boolean closed = true;

    public AMQPMessageReader(ProtonAbstractReceiver serverReceiver) {
        this.serverReceiver = serverReceiver;
    }

    @Override
    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    @Override
    public void close() {
        this.closed = true;
        this.deliveryAnnotations = null;
    }

    @Override
    public MessageReader open() {
        if (!this.closed) {
            throw new IllegalStateException("Message reader must be properly closed before open call");
        }
        return this;
    }

    @Override
    public Message readBytes(Delivery delivery) {
        if (delivery.isPartial()) {
            return null;
        }
        Receiver receiver = (Receiver)delivery.getLink();
        ReadableBuffer payload = receiver.recv();
        AMQPStandardMessage message = this.serverReceiver.getSessionContext().getSessionSPI().createStandardMessage(delivery, payload);
        this.deliveryAnnotations = message.getDeliveryAnnotations();
        return message;
    }
}

