/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.InternalStages;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsEngineResolver;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsGraphBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.Reductions;
import org.eclipse.microprofile.reactive.streams.operators.core.Stages;
import org.eclipse.microprofile.reactive.streams.operators.core.SubscriberBuilderImpl;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ProcessorBuilderImpl<T, R>
extends ReactiveStreamsGraphBuilder
implements ProcessorBuilder<T, R> {
    ProcessorBuilderImpl(Stage stage, ReactiveStreamsGraphBuilder previous) {
        super(stage, previous);
    }

    public <S> ProcessorBuilder<T, S> map(Function<? super R, ? extends S> mapper) {
        return this.addStage((Stage)new Stages.Map(mapper));
    }

    public ProcessorBuilder<T, R> peek(Consumer<? super R> consumer) {
        return this.addStage((Stage)new Stages.Peek(consumer));
    }

    public ProcessorBuilder<T, R> filter(Predicate<? super R> predicate) {
        return this.addStage((Stage)new Stages.Filter(predicate));
    }

    public ProcessorBuilder<T, R> distinct() {
        return this.addStage((Stage)Stages.Distinct.INSTANCE);
    }

    public <S> ProcessorBuilder<T, S> flatMap(Function<? super R, ? extends PublisherBuilder<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMap(mapper.andThen(ReactiveStreamsGraphBuilder::rsBuilderToGraph)));
    }

    public <S> ProcessorBuilder<T, S> flatMapRsPublisher(Function<? super R, ? extends Publisher<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMap(mapper.andThen(ReactiveStreamsGraphBuilder::publisherToGraph)));
    }

    public <S> ProcessorBuilder<T, S> flatMapCompletionStage(Function<? super R, ? extends CompletionStage<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMapCompletionStage(mapper));
    }

    public <S> ProcessorBuilder<T, S> flatMapIterable(Function<? super R, ? extends Iterable<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMapIterable(mapper));
    }

    public ProcessorBuilder<T, R> limit(long maxSize) {
        return this.addStage((Stage)new Stages.Limit(maxSize));
    }

    public ProcessorBuilder<T, R> skip(long n) {
        return this.addStage((Stage)new Stages.Skip(n));
    }

    public ProcessorBuilder<T, R> takeWhile(Predicate<? super R> predicate) {
        return this.addStage((Stage)new Stages.TakeWhile(predicate));
    }

    public ProcessorBuilder<T, R> dropWhile(Predicate<? super R> predicate) {
        return this.addStage((Stage)new Stages.DropWhile(predicate));
    }

    public SubscriberBuilder<T, Void> forEach(Consumer<? super R> action) {
        Objects.requireNonNull(action, "Action must not be null");
        return this.collect(Collector.of(() -> null, (n, r) -> action.accept((Object)r), (v1, v2) -> null, v -> null, new Collector.Characteristics[0]));
    }

    public SubscriberBuilder<T, Void> ignore() {
        return this.forEach((? super R r) -> {});
    }

    public SubscriberBuilder<T, Void> cancel() {
        return this.addTerminalStage((Stage)Stages.Cancel.INSTANCE);
    }

    public SubscriberBuilder<T, R> reduce(R identity, BinaryOperator<R> accumulator) {
        return this.addTerminalStage((Stage)new Stages.Collect(Reductions.reduce(identity, accumulator)));
    }

    public SubscriberBuilder<T, Optional<R>> reduce(BinaryOperator<R> accumulator) {
        return this.addTerminalStage((Stage)new Stages.Collect(Reductions.reduce(accumulator)));
    }

    public <S, A> SubscriberBuilder<T, S> collect(Collector<? super R, A, S> collector) {
        return this.addTerminalStage((Stage)new Stages.Collect(collector));
    }

    public <S> SubscriberBuilder<T, S> collect(Supplier<S> supplier, BiConsumer<S, ? super R> accumulator) {
        return this.addTerminalStage((Stage)new Stages.Collect(Collector.of(supplier, accumulator, (a, b) -> a, new Collector.Characteristics[0])));
    }

    public SubscriberBuilder<T, List<R>> toList() {
        return this.collect(Collectors.toList());
    }

    public SubscriberBuilder<T, Optional<R>> findFirst() {
        return this.addTerminalStage((Stage)Stages.FindFirst.INSTANCE);
    }

    public SubscriberBuilder<T, Void> to(Subscriber<? super R> subscriber) {
        return this.addTerminalStage((Stage)new Stages.SubscriberStage(subscriber));
    }

    public <S> SubscriberBuilder<T, S> to(SubscriberBuilder<? super R, ? extends S> subscriber) {
        return this.addTerminalStage(InternalStages.nested(subscriber));
    }

    public ProcessorBuilder<T, R> onError(Consumer<Throwable> errorHandler) {
        return this.addStage((Stage)new Stages.OnError(errorHandler));
    }

    public ProcessorBuilder<T, R> onErrorResume(Function<Throwable, ? extends R> errorHandler) {
        return this.addStage((Stage)new Stages.OnErrorResume(errorHandler));
    }

    public ProcessorBuilder<T, R> onErrorResumeWith(Function<Throwable, ? extends PublisherBuilder<? extends R>> errorHandler) {
        return this.addStage((Stage)new Stages.OnErrorResumeWith(errorHandler.andThen(ReactiveStreamsGraphBuilder::rsBuilderToGraph)));
    }

    public ProcessorBuilder<T, R> onErrorResumeWithRsPublisher(Function<Throwable, ? extends Publisher<? extends R>> errorHandler) {
        return this.addStage((Stage)new Stages.OnErrorResumeWith(errorHandler.andThen(ReactiveStreamsGraphBuilder::publisherToGraph)));
    }

    public ProcessorBuilder<T, R> onTerminate(Runnable action) {
        return this.addStage((Stage)new Stages.OnTerminate(action));
    }

    public ProcessorBuilder<T, R> onComplete(Runnable action) {
        return this.addStage((Stage)new Stages.OnComplete(action));
    }

    public <S> ProcessorBuilder<T, S> via(ProcessorBuilder<? super R, ? extends S> processor) {
        return this.addStage(InternalStages.nested(processor));
    }

    public <S> ProcessorBuilder<T, S> via(Processor<? super R, ? extends S> processor) {
        return this.addStage((Stage)new Stages.ProcessorStage(processor));
    }

    public Processor<T, R> buildRs() {
        return this.buildRs(ReactiveStreamsEngineResolver.instance());
    }

    public Processor<T, R> buildRs(ReactiveStreamsEngine engine) {
        Objects.requireNonNull(engine, "Engine must not be null");
        return engine.buildProcessor(this.toGraph());
    }

    private <S> ProcessorBuilder<T, S> addStage(Stage stage) {
        return new ProcessorBuilderImpl<T, R>(stage, this);
    }

    private <S> SubscriberBuilder<T, S> addTerminalStage(Stage stage) {
        return new SubscriberBuilderImpl(stage, this);
    }
}

