/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchNestableAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchBucketAggregation<K, V>
extends AbstractElasticsearchNestableAggregation<Map<K, V>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonObject> REQUEST_REVERSE_NESTED_ACCESSOR = JsonAccessor.root().property("reverse_nested").asObject();
    private static final String ROOT_DOC_COUNT_NAME = "root_doc_count";
    private static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_ROOT_DOC_COUNT_ACCESSOR = JsonAccessor.root().property("aggregations").property("root_doc_count").asObject();
    private static final JsonAccessor<Long> RESPONSE_DOC_COUNT_ACCESSOR = JsonAccessor.root().property("doc_count").asLong();
    private static final JsonAccessor<Long> RESPONSE_ROOT_DOC_COUNT_ACCESSOR = JsonAccessor.root().property("root_doc_count").property("doc_count").asLong();

    AbstractElasticsearchBucketAggregation(AbstractBuilder<K, V> builder) {
        super(builder);
    }

    @Override
    protected final JsonObject doRequest(AggregationRequestContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        this.doRequest(outerObject, innerObject);
        if (this.isNested()) {
            JsonObject rootDocCountSubAggregationOuterObject = new JsonObject();
            JsonObject rootDocCountSubAggregationInnerObject = new JsonObject();
            REQUEST_REVERSE_NESTED_ACCESSOR.set(rootDocCountSubAggregationOuterObject, rootDocCountSubAggregationInnerObject);
            REQUEST_AGGREGATIONS_ROOT_DOC_COUNT_ACCESSOR.set(outerObject, rootDocCountSubAggregationOuterObject);
        }
        return outerObject;
    }

    protected abstract void doRequest(JsonObject var1, JsonObject var2);

    protected final long getBucketDocCount(JsonObject bucket) {
        if (this.isNested()) {
            return RESPONSE_ROOT_DOC_COUNT_ACCESSOR.get(bucket).orElseThrow(log::elasticsearchResponseMissingData);
        }
        return RESPONSE_DOC_COUNT_ACCESSOR.get(bucket).orElseThrow(log::elasticsearchResponseMissingData);
    }

    public static abstract class AbstractBuilder<K, V>
    extends AbstractElasticsearchNestableAggregation.AbstractBuilder<Map<K, V>> {
        public AbstractBuilder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field) {
            super(scope, field);
        }

        @Override
        public abstract ElasticsearchSearchAggregation<Map<K, V>> build();
    }

    protected abstract class AbstractBucketExtractor<A, B>
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<Map<A, B>> {
        protected AbstractBucketExtractor(List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter) {
            super(nestedPathHierarchy, filter);
        }

        @Override
        protected final Map<A, B> doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            JsonElement buckets = aggregationResult.get("buckets");
            return this.doExtract(context, buckets);
        }

        protected abstract Map<A, B> doExtract(AggregationExtractContext var1, JsonElement var2);
    }
}

