/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];

    T4C8TTIClob(T4CConnection t4CConnection) {
        super(t4CConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long read(byte[] byArray, long l2, long l3, boolean bl, char[] cArray, int n2) throws SQLException, IOException {
        long l4;
        byte[] byArray2 = null;
        try {
            this.initializeLobdef();
            boolean bl2 = this.isLobCharsetVariableWidth(byArray);
            int n3 = this.getByteBufferSizeForConversion(bl2, l3);
            byArray2 = this.connection.getByteBuffer(n3);
            this.littleEndianClob = this.isLobCharsetLE(byArray);
            this.lobops = 2L;
            this.sourceLobLocator = byArray;
            this.sourceOffset = l2;
            this.lobamt = l3;
            this.sendLobamt = true;
            this.outBuffer = byArray2;
            this.doRPC();
            long l5 = this.lobamt;
            this.decodeNetworkCharSet(cArray, n2, bl2, bl);
            l4 = l5;
            this.outBuffer = null;
        }
        catch (Throwable throwable) {
            this.outBuffer = null;
            this.connection.cacheBuffer(byArray2);
            throw throwable;
        }
        this.connection.cacheBuffer(byArray2);
        return l4;
    }

    final boolean isLobCharsetVariableWidth(byte[] byArray) {
        return (byArray[6] & 0xFFFFFF80) == -128;
    }

    final int getByteBufferSizeForConversion(boolean bl, long l2) {
        if (bl) {
            return (int)l2 * 2;
        }
        return (int)l2 * 3;
    }

    private final boolean isLobCharsetLE(byte[] byArray) {
        return 64 == (byArray[7] & 0x40);
    }

    private final void decodeNetworkCharSet(char[] cArray, int n2, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            this.decodeVariableWidthCharSet(cArray, n2);
        } else {
            this.decodeFixedWidthCharSet(cArray, n2, bl2);
        }
    }

    private final void decodeVariableWidthCharSet(char[] cArray, int n2) throws SQLException {
        if (this.connection.versionNumber < 10101) {
            DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, cArray);
        } else if (this.littleEndianClob) {
            CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
        } else {
            CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
        }
    }

    private final void decodeFixedWidthCharSet(char[] cArray, int n2, boolean bl) throws SQLException {
        if (!bl) {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
        } else {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
        }
    }

    long write(byte[] byArray, long l2, boolean bl, char[] cArray, long l3, long l4) throws SQLException, IOException {
        this.validateLobOperation(byArray, 64, "write()");
        boolean bl2 = this.isLobCharsetVariableWidth(byArray);
        this.littleEndianClob = this.isLobCharsetLE(byArray);
        int n2 = this.getByteBufferSizeForConversion(bl2, l4);
        byte[] byArray2 = new byte[n2];
        int n3 = this.encodeNetworkCharSet(cArray, (int)l3, (int)l4, byArray2, bl2, bl);
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l4;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = n3;
        this.doRPC();
        return this.lobamt;
    }

    final int encodeNetworkCharSet(char[] cArray, int n2, int n3, byte[] byArray, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            return this.encodeVariableWidthCharSet(cArray, n2, n3, byArray);
        }
        return this.encodeFixedWidthCharSet(cArray, n2, n3, byArray, bl2);
    }

    private final int encodeVariableWidthCharSet(char[] cArray, int n2, int n3, byte[] byArray) throws SQLException {
        if (this.connection.versionNumber < 10101) {
            DBConversion.javaCharsToUcs2Bytes(cArray, n2, byArray, 0, n3);
            return n3;
        }
        if (this.littleEndianClob) {
            CharacterSet.convertJavaCharsToAL16UTF16LEBytes(cArray, n2, byArray, 0, n3);
            return n3 * 2;
        }
        CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, n2, byArray, 0, n3);
        return n3 * 2;
    }

    private final int encodeFixedWidthCharSet(char[] cArray, int n2, int n3, byte[] byArray, boolean bl) throws SQLException {
        if (!bl) {
            return this.meg.conv.javaCharsToCHARBytes(cArray, n2, byArray, 0, n3);
        }
        return this.meg.conv.javaCharsToNCHARBytes(cArray, n2, byArray, 0, n3);
    }

    @Override
    Datum createTemporaryLob(Connection connection, boolean bl, int n2) throws SQLException, IOException {
        return this.createTemporaryLob(connection, bl, n2, (short)1);
    }

    Datum createTemporaryLob(Connection connection, boolean bl, int n2, short s2) throws SQLException, IOException {
        if (n2 == 12) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158).fillInStackTrace();
        }
        CLOB cLOB = null;
        this.initializeLobdef();
        this.lobops = 272L;
        int n3 = this.getTemporaryLobSize();
        this.sourceLobLocator = new byte[n3];
        this.sourceLobLocator[1] = (byte)(n3 - 2);
        this.sourceOffset = s2 == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = n2;
        this.lobamt = n2;
        this.sendLobamt = true;
        this.nullO2U = true;
        short s3 = this.characterSet = s2 == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = bl ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            cLOB = s2 == 1 ? new CLOB((OracleConnection)connection, this.sourceLobLocator) : new NCLOB((OracleConnection)connection, this.sourceLobLocator);
        }
        return cLOB;
    }

    @Override
    boolean open(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = false;
        int n3 = 2;
        if (n2 == 0) {
            n3 = 1;
        }
        bl = this._open(byArray, n3, 32768);
        return bl;
    }

    @Override
    boolean close(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._close(byArray, 65536);
        return bl;
    }

    @Override
    boolean isOpen(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._isOpen(byArray, 69632);
        return bl;
    }
}

