/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public interface Monitor {
    public CloseableLock getMonitorLock();

    default public CloseableLock newDefaultLock() {
        return CloseableLock.wrap(new ReentrantLock());
    }

    default public CloseableLock acquireCloseableLock() {
        this.acquireLock();
        return this.getMonitorLock();
    }

    default public void acquireLock() {
        this.getMonitorLock().lock.lock();
    }

    default public void releaseLock() {
        this.getMonitorLock().lock.unlock();
    }

    public static Monitor newInstance() {
        class MonitorImpl
        implements Monitor,
        Serializable {
            private static final long serialVersionUID = -2318644678533776943L;
            private final CloseableLock monitorLock = this.newDefaultLock();

            MonitorImpl() {
            }

            @Override
            public CloseableLock getMonitorLock() {
                return this.monitorLock;
            }
        }
        return new MonitorImpl();
    }

    public static final class CloseableLock
    implements AutoCloseable,
    Serializable {
        private static final long serialVersionUID = -285233395800863549L;
        private final Lock lock;

        private CloseableLock(Lock lock) {
            this.lock = lock;
        }

        public static CloseableLock wrap(Lock lock) {
            return new CloseableLock(lock);
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    public static interface WaitableMonitor
    extends Monitor {
        public Condition getMonitorCondition();

        default public Condition newMonitorCondition() {
            return this.getMonitorLock().lock.newCondition();
        }

        default public void monitorWait() throws InterruptedException {
            this.getMonitorCondition().await();
        }

        default public void monitorWait(long l2) throws InterruptedException {
            this.monitorWait(l2, 0);
        }

        default public void monitorWait(long l2, int n2) throws InterruptedException {
            if (!1.$assertionsDisabled && l2 < 0L) {
                throw new AssertionError((Object)"Negative millisecond timeout");
            }
            if (!1.$assertionsDisabled && n2 < 0) {
                throw new AssertionError((Object)"Negative nanosecond timeout");
            }
            this.getMonitorCondition().awaitNanos(TimeUnit.MILLISECONDS.toNanos(l2) + (long)n2);
        }

        default public void monitorNotify() {
            this.getMonitorCondition().signal();
        }

        default public void monitorNotifyAll() {
            this.getMonitorCondition().signalAll();
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

