/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentValueConverter;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public final class DslConverter<V, F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Class<V> valueType;
    private final ToDocumentValueConverter<V, ? extends F> delegate;

    public static <F> DslConverter<F, F> passThrough(Class<F> fieldAndValueType) {
        return new DslConverter<F, F>(fieldAndValueType, new PassThroughToDocumentValueConverter());
    }

    public DslConverter(Class<V> valueType, ToDocumentValueConverter<V, ? extends F> delegate) {
        Contracts.assertNotNull(valueType, (String)"valueType");
        Contracts.assertNotNull(delegate, (String)"delegate");
        this.valueType = valueType;
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[valueType=" + this.valueType.getName() + ",delegate=" + String.valueOf(this.delegate) + "]";
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    public F toDocumentValue(V value, ToDocumentValueConvertContext context) {
        return this.delegate.toDocumentValue(value, context);
    }

    public F unknownTypeToDocumentValue(Object value, ToDocumentValueConvertContext context) {
        return this.delegate.toDocumentValue(this.valueType.cast(value), context);
    }

    public <T> DslConverter<? super T, F> withInputType(Class<T> inputTypeCandidate, EventContextProvider eventContextProvider) {
        if (!this.valueType.isAssignableFrom(inputTypeCandidate)) {
            throw log.invalidDslArgumentType(inputTypeCandidate, this.valueType, eventContextProvider.eventContext());
        }
        return this;
    }

    public boolean isCompatibleWith(DslConverter<?, ?> other) {
        return this.delegate.isCompatibleWith(other.delegate);
    }
}

