/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class TimeoutExecution {
    private static final int STATE_RUNNING = 0;
    private static final int STATE_FINISHED = 1;
    private static final int STATE_TIMED_OUT = 2;
    private static final VarHandle STATE;
    private volatile int state = 0;
    private final Thread executingThread;
    private final Runnable timeoutAction;
    private final long timeoutInMillis;

    TimeoutExecution(Thread executingThread, long timeoutInMillis) {
        this(executingThread, timeoutInMillis, null);
    }

    TimeoutExecution(Thread executingThread, long timeoutInMillis, Runnable timeoutAction) {
        this.executingThread = executingThread;
        this.timeoutInMillis = timeoutInMillis;
        this.timeoutAction = timeoutAction;
    }

    long timeoutInMillis() {
        return this.timeoutInMillis;
    }

    boolean isRunning() {
        return this.state == 0;
    }

    boolean hasFinished() {
        return this.state == 1;
    }

    boolean hasTimedOut() {
        return this.state == 2;
    }

    void finish(Runnable ifFinished) {
        if (STATE.compareAndSet(this, 0, 1)) {
            ifFinished.run();
        }
    }

    void timeoutAndInterrupt() {
        if (STATE.compareAndSet(this, 0, 2)) {
            if (this.executingThread != null) {
                this.executingThread.interrupt();
            }
            if (this.timeoutAction != null) {
                this.timeoutAction.run();
            }
        }
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(TimeoutExecution.class, "state", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

