/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.InvocationIdentifier;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;
import org.wildfly.transaction.client.LocalTransactionContext;

class HttpCancelHandler
extends RemoteHTTPHandler {
    private final Association association;
    private final ExecutorService executorService;
    private final LocalTransactionContext localTransactionContext;
    private final Map<InvocationIdentifier, CancelHandle> cancellationFlags;

    HttpCancelHandler(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Map<InvocationIdentifier, CancelHandle> cancellationFlags) {
        super(executorService);
        this.association = association;
        this.executorService = executorService;
        this.localTransactionContext = localTransactionContext;
        this.cancellationFlags = cancellationFlags;
    }

    @Override
    protected void handleInternal(HttpServerExchange exchange) throws Exception {
        String sessionAffinity;
        String[] parts;
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        ContentType contentType = ContentType.parse(ct);
        if (contentType != null) {
            exchange.setStatusCode(400);
            EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", (Object)ct);
            return;
        }
        String relativePath = exchange.getRelativePath();
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((parts = relativePath.split("/")).length != 6) {
            exchange.setStatusCode(404);
            return;
        }
        String app = HttpCancelHandler.handleDash(parts[0]);
        String module = HttpCancelHandler.handleDash(parts[1]);
        String distinct = HttpCancelHandler.handleDash(parts[2]);
        String bean = parts[3];
        String invocationId = parts[4];
        boolean cancelIdRunning = Boolean.parseBoolean(parts[5]);
        Cookie cookie = exchange.getRequestCookie("JSESSIONID");
        String string = sessionAffinity = cookie != null ? cookie.getValue() : null;
        if (invocationId == null || sessionAffinity == null) {
            exchange.setStatusCode(400);
            EjbHttpClientMessages.MESSAGES.debugf("Exchange %s did not include both session id and invocation id in cancel request", (Object)exchange);
            return;
        }
        InvocationIdentifier identifier = new InvocationIdentifier(invocationId, sessionAffinity);
        CancelHandle handle = this.cancellationFlags.remove(identifier);
        if (handle != null) {
            handle.cancel(cancelIdRunning);
        }
    }

    private static String handleDash(String s) {
        if (s.equals("-")) {
            return "";
        }
        return s;
    }
}

