$httpRequestMethod = "POST"
$xmlHttpRequestUrl = "http://localhost:8080/RCSDMWebServices/Manager?wsdl"
$xmlSoapNamespace = "soap"
$webServiceMethodName = "getNativeSingleResultAsJsonObject"
$webServiceCallBody = "<stmt>select text from xm_lang_data where id = ? and language = ?</stmt><positionalParametersAsJson>[`"%dic_shoe%`", `"en`"]</positionalParametersAsJson>"
$contentType = "text/xml"
$accept = "text/xml"
$xmlHeader = ""
$xmlWebServiceNamespace = "ws"
$soapEnvelopeStartTag = "<" + $xmlSoapNamespace + ":Envelope xmlns:" + $xmlSoapNamespace + "=`"http://schemas.xmlsoap.org/soap/envelope/`">"
$soapBodyStartTag = "<" + $xmlSoapNamespace + ":Body>"
$webServiceCallStartTag = "<" + $xmlWebServiceNamespace + ":" + $webServiceMethodName + " xmlns:" + $xmlWebServiceNamespace + "=`"http://services.webservices.rcsdm.cadwin.com/`">"
$webServiceCallEndTag = "</" + $xmlWebServiceNamespace + ":" + $webServiceMethodName + ">"
$soapBodyEndTag = "</" + $xmlSoapNamespace + ":Body>"
$soapEnvelopeEndTag = "</" + $xmlSoapNamespace + ":Envelope>"
$httpRequestBody = $xmlHeader + $soapEnvelopeStartTag + $soapBodyStartTag + $webServiceCallStartTag + $webServiceCallBody + $webServiceCallEndTag + $soapBodyEndTag + $soapEnvelopeEndTag
$response = Invoke-WebRequest $xmlHttpRequestUrl -contentType $contentType -headers @{"accept"=$accept} -method $httpRequestMethod -body $httpRequestBody
if ($response.StatusCode -eq 200) {
    $responseText = $response.Content
    $xmlDoc = New-Object -TypeName System.Xml.XmlDocument
    $xmlDoc.LoadXml($responseText)
    if ($xmlDoc.FirstChild -ne $null -and $xmlDoc.FirstChild.Name -eq $xmlSoapNamespace + ":Envelope" -and $xmlDoc.FirstChild.FirstChild -ne $null -and $xmlDoc.FirstChild.FirstChild.Name -eq $xmlSoapNamespace + ":Body") {
        $returnXmlNodeList = $xmlDoc.GetElementsByTagName("return")
        if ($returnXmlNodeList.Count -gt 0) {
            $soapReturnNode = $returnXmlNodeList.Item(0)
            if ($soapReturnNode -ne $null) {
                $soapReturnNodeTextContent = $soapReturnNode.InnerText
                ($soapReturnNodeTextContent | ConvertFrom-Json).TEXT
            }
        }
    }
}