/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.dictionnary;

import com.cadwin.basic.misc.LocaleUtil;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DictionnaryValue
implements Serializable,
Cloneable {
    private static final String ELLIPSE_TAG = "...";
    private static final String TWO_POINTS_TAG = ":";
    private LinkedHashMap<Locale, String> values = new LinkedHashMap();
    private String toString;
    private String defaultValue;
    private boolean differentValues;
    private Process process = Process.NONE;

    public static DictionnaryValue clone(DictionnaryValue other) {
        if (other != null) {
            try {
                return (DictionnaryValue)other.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTokenWithProcess(String token, Process process) {
        switch (process) {
            case NONE: {
                return token;
            }
            case ELLIPSE: {
                return token + ELLIPSE_TAG;
            }
            case TWO_POINTS: {
                return token + TWO_POINTS_TAG;
            }
        }
        throw new AssertionError((Object)("Invalid enum value " + process));
    }

    public static ProcessToken getProcessToken(String token) {
        if (token.endsWith(ELLIPSE_TAG)) {
            return new ProcessToken(token.substring(0, token.length() - ELLIPSE_TAG.length()), Process.ELLIPSE);
        }
        if (token.endsWith(TWO_POINTS_TAG)) {
            return new ProcessToken(token.substring(0, token.length() - TWO_POINTS_TAG.length()), Process.TWO_POINTS);
        }
        return new ProcessToken(token, Process.NONE);
    }

    public DictionnaryValue() {
    }

    public DictionnaryValue(boolean differentValues) {
        this.differentValues = differentValues;
    }

    public DictionnaryValue(String toString) {
        this.toString = toString;
    }

    public DictionnaryValue(DictionnaryValue dicValue, Process process) {
        this.values = dicValue.values;
        this.defaultValue = dicValue.defaultValue;
        this.process = process;
    }

    public boolean isDifferentValues() {
        return this.differentValues;
    }

    public void add(Locale locale, String value) {
        if (value == null || value.isEmpty()) {
            this.values.remove(locale);
        } else {
            this.values.put(locale, value);
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLocale() {
        return !this.values.isEmpty();
    }

    private String process(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        switch (this.process) {
            case NONE: {
                return value;
            }
            case ELLIPSE: {
                return value + ELLIPSE_TAG;
            }
            case TWO_POINTS: {
                if (LocaleUtil.isCompatible(locale, Locale.FRENCH)) {
                    return value + " :";
                }
                return value + TWO_POINTS_TAG;
            }
        }
        throw new AssertionError((Object)("Invalid enum value " + this.process));
    }

    public String get(Locale locale) {
        String value;
        String string = value = this.hasDefaultValue() ? this.getDefaultValue() : this.values.get(locale);
        if (value == null) {
            value = this.values.entrySet().stream().filter(valueEntry -> LocaleUtil.isCompatible(locale, (Locale)valueEntry.getKey())).map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(null);
            if (value == null) {
                value = this.values.get(Locale.ENGLISH);
            }
            if (value == null && this.toString != null) {
                value = this.toString;
            }
            if (value == null && !this.values.values().isEmpty()) {
                value = this.values.values().iterator().next();
            }
        }
        return this.process(value, locale);
    }

    public String getExactly(Locale locale) {
        String value = this.hasDefaultValue() ? this.getDefaultValue() : this.values.get(locale);
        return this.process(value, locale);
    }

    public boolean exists(Locale locale) {
        return this.values.containsKey(locale);
    }

    public Locale[] getLocales() {
        Set<Locale> keySet = this.values.keySet();
        if (keySet.isEmpty()) {
            return new Locale[]{Locale.getDefault()};
        }
        return keySet.toArray(new Locale[keySet.size()]);
    }

    public String toString() {
        return Objects.toString(this.get(Locale.getDefault()), "");
    }

    public int hashCode() {
        return Objects.hash(this.values, this.defaultValue);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else if (this == obj) {
            result = true;
        } else {
            DictionnaryValue other = (DictionnaryValue)obj;
            result = Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.values, other.values);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        DictionnaryValue o = (DictionnaryValue)super.clone();
        if (this.values != null) {
            o.values = (LinkedHashMap)this.values.clone();
        }
        return o;
    }

    public static enum Process {
        NONE,
        ELLIPSE,
        TWO_POINTS;

    }

    public static class ProcessToken {
        private final String token;
        private final Process process;

        public ProcessToken(String token, Process process) {
            this.token = token;
            this.process = process;
        }

        public String getToken() {
            return this.token;
        }

        public Process getProcess() {
            return this.process;
        }
    }
}

