/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.encryption;

import com.cadwin.basic.encryption.Crypto;
import com.cadwin.basic.encryption.CryptoException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptoHelper {
    public static final String AES_GCM_TRANSFORMATION = "AES/GCM/NoPadding";
    public static final String AES_ALGORYTHM = "AES";
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 128;

    private CryptoHelper() {
    }

    public static CryptoException buildCryptoException(String msg, Throwable throwable) {
        return new CryptoException(String.format("Error while %s", msg), throwable);
    }

    public static byte[] getBytes(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static SecretKey getSecretKey(String secretKey) {
        return new SecretKeySpec(CryptoHelper.getBytes(secretKey), AES_ALGORYTHM);
    }

    public static String encrypt(String valueToEncrypt, Crypto crypto) throws CryptoException {
        return Base64.getEncoder().encodeToString(crypto.encrypt(valueToEncrypt));
    }

    public static String decrypt(String valueToDecrypt, Crypto crypto) throws CryptoException {
        return crypto.decrypt(Base64.getDecoder().decode(valueToDecrypt));
    }
}

