/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.encryption;

import com.cadwin.basic.encryption.CryptoException;
import com.cadwin.basic.encryption.CryptoHelper;
import com.cadwin.basic.io.IoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class CryptoIO {
    private final Cipher cipher;
    private final SecretKey secretKey;
    private final GCMParameterSpec ivSpec;

    public CryptoIO(String secretKey, String initVector) throws CryptoException {
        this.ivSpec = new GCMParameterSpec(128, CryptoHelper.getBytes(initVector));
        try {
            this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
            this.secretKey = CryptoHelper.getSecretKey(secretKey);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            throw CryptoHelper.buildCryptoException("creating CryptoIO", ex);
        }
    }

    public void encryptStream(InputStream is, OutputStream os) throws CryptoException {
        try {
            this.cipher.init(1, (Key)this.secretKey, this.ivSpec);
            try (CipherOutputStream cos = new CipherOutputStream(os, this.cipher);
                 BufferedOutputStream bos = new BufferedOutputStream(cos);
                 BufferedInputStream bis = new BufferedInputStream(is);){
                IoUtil.copy(bis, bos);
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException ex) {
            throw CryptoHelper.buildCryptoException("encrypting stream", ex);
        }
    }

    public void decryptStream(InputStream is, OutputStream os) throws CryptoException {
        try {
            this.cipher.init(2, (Key)this.secretKey, this.ivSpec);
            try (CipherInputStream cis = new CipherInputStream(is, this.cipher);
                 BufferedInputStream bis = new BufferedInputStream(cis);
                 BufferedOutputStream bos = new BufferedOutputStream(os);){
                IoUtil.copy(bis, bos);
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException ex) {
            throw CryptoHelper.buildCryptoException("decrypting stream", ex);
        }
    }
}

