/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.jdbc;

public class OracleHelper {
    public static String getUrl(String host, int port, String sidOrService, boolean isService) {
        String pattern = String.format("jdbc:oracle:thin:@%s", isService ? "//%s:%d/%s" : "%s:%d:%s");
        return String.format(pattern, host, port, sidOrService);
    }

    public static String getAsSysDbaLogon(String username, boolean onlyIfSysUser) {
        if (onlyIfSysUser && !username.equalsIgnoreCase("sys")) {
            return username;
        }
        return String.format("%s as sysdba", username);
    }

    public static String getSysDbaLogon() {
        return OracleHelper.getAsSysDbaLogon("sys", true);
    }

    private OracleHelper() {
    }
}

