/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.ldap;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapUtil {
    private static Hashtable<String, String> fillLdapEnv(String providerURL, String securityAuthentication) {
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.provider.url", providerURL);
        ldapEnv.put("java.naming.security.authentication", securityAuthentication);
        return ldapEnv;
    }

    public static DirContext getContext(String providerURL, String securityAuthentication, String securityPrincipal, String securityCredentials) throws NamingException {
        Hashtable<String, String> ldapEnv = LdapUtil.fillLdapEnv(providerURL, securityAuthentication);
        ldapEnv.put("java.naming.security.principal", securityPrincipal);
        ldapEnv.put("java.naming.security.credentials", securityCredentials);
        return new InitialDirContext(ldapEnv);
    }

    public static DirContext getContext(String providerURL, String securityPrincipal, String securityCredentials) throws NamingException {
        return LdapUtil.getContext(providerURL, "simple", securityPrincipal, securityCredentials);
    }

    public static DirContext getContext(String providerURL) throws NamingException {
        Hashtable<String, String> ldapEnv = LdapUtil.fillLdapEnv(providerURL, "none");
        return new InitialDirContext(ldapEnv);
    }

    public static String getCn(DirContext ctx, String baseDN, String basedAuthentication, String subTree, String loginAttributeName, String username) throws NamingException {
        SearchControls sc = new SearchControls();
        String[] attributeFilter = new String[]{loginAttributeName, basedAuthentication};
        String result = null;
        sc.setReturningAttributes(attributeFilter);
        sc.setSearchScope(2);
        String base = (String)(subTree.length() == 0 ? "" : subTree + ",") + baseDN;
        String filter = "(&(" + loginAttributeName + "=" + username + ") )";
        NamingEnumeration<SearchResult> results = ctx.search(base, filter, sc);
        if (results.hasMore()) {
            SearchResult sr = results.next();
            Attributes attrs = sr.getAttributes();
            Attribute attr = attrs.get(basedAuthentication);
            result = (String)attr.get();
        }
        return result;
    }

    private LdapUtil() {
    }
}

