/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CollectionHelper {
    public <T> boolean setAll(Collection<? super T> dest, Collection<? extends T> src) {
        boolean changed;
        if (src == null || src.isEmpty()) {
            if (dest.isEmpty()) {
                changed = false;
            } else {
                dest.clear();
                changed = true;
            }
        } else if (dest.isEmpty()) {
            changed = dest.addAll(src);
        } else if (Collections.disjoint(dest, src)) {
            dest.clear();
            dest.addAll(src);
            changed = true;
        } else {
            boolean elementsRemoved = dest.retainAll(src);
            ArrayList<T> newElements = new ArrayList<T>(src);
            newElements.removeAll(dest);
            boolean elementsAdded = dest.addAll(newElements);
            changed = elementsRemoved || elementsAdded;
        }
        return changed;
    }
}

