/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.NumberUtil;
import java.awt.Color;
import java.awt.color.ColorSpace;

public class ColorUtil {
    private static final ColorSpace CIEXYZ_COLOR_SPACE = ColorSpace.getInstance(1001);
    private static final float[] XYZ_CN = Color.WHITE.getColorComponents(CIEXYZ_COLOR_SPACE, null);
    private static final double CIE_LAB_LIMIT = 0.008856;
    private static final double CUBIC = 0.3333333333333333;

    public static double distance(Color c1, Color c2) {
        double[] cp1 = ColorUtil.getCIELab(c1);
        double[] cp2 = ColorUtil.getCIELab(c2);
        double f = 0.0;
        for (int i = 0; i < cp1.length; ++i) {
            double g = cp1[i] - cp2[i];
            f += g * g;
        }
        return Math.sqrt(f);
    }

    public static double distance(int rgb1, int rgb2) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        double[] cp1 = ColorUtil.getCIELab(cs, rgb1);
        double[] cp2 = ColorUtil.getCIELab(cs, rgb2);
        double f = 0.0;
        for (int i = 0; i < cp1.length; ++i) {
            double g = cp1[i] - cp2[i];
            f += g * g;
        }
        return Math.sqrt(f);
    }

    public static Color oppositeColor(Color color) {
        if (color != null) {
            Color oppositteColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
            if (ColorUtil.distance(oppositteColor, color) < 0.5) {
                return Color.WHITE;
            }
            return oppositteColor;
        }
        return Color.BLACK;
    }

    public static String colorToString(Color color) {
        return ColorUtil.getHtmlColor(color);
    }

    public static Color stringToColor(String value) {
        if (value == null || value.length() < 1) {
            return null;
        }
        if (value.startsWith("#") && value.length() == 7) {
            String red = value.substring(1, 3);
            String green = value.substring(3, 5);
            String blue = value.substring(5, 7);
            try {
                return new Color(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (value.startsWith("rgb(")) {
            String[] split = value.substring(4, value.length() - 1).split(",");
            if (split != null && split.length == 3) {
                try {
                    return new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        } else {
            int sRGB = NumberUtil.intValue(value);
            if (sRGB != Integer.MIN_VALUE) {
                return new Color(sRGB);
            }
        }
        return null;
    }

    public static Color getDisabledColor(Color c) {
        Color result;
        if (c == null) {
            result = null;
        } else {
            float[] hsb = new float[3];
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
            float hue = hsb[0];
            float saturation = hsb[1];
            float brightness = hsb[2];
            result = new Color(Color.HSBtoRGB(hue, saturation * 0.5f, brightness * 0.9f));
        }
        return result;
    }

    public static String getHtmlColor(Color color) {
        if (color == null) {
            return null;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        String sRed = Integer.toHexString(red);
        String sGreen = Integer.toHexString(green);
        String sBlue = Integer.toHexString(blue);
        Object fRed = sRed.length() == 1 ? "0" + sRed : sRed;
        Object fGreen = sGreen.length() == 1 ? "0" + sGreen : sGreen;
        Object fBlue = sBlue.length() == 1 ? "0" + sBlue : sBlue;
        return "#" + (String)fRed + (String)fGreen + (String)fBlue;
    }

    private static double getFuncCIELab(double t) {
        if (t > 0.008856) {
            return Math.pow(t, 0.3333333333333333);
        }
        return 7.7787 * t + 0.13793103448275862;
    }

    private static float[] getColorComponents(int rgb, ColorSpace sourceCS, ColorSpace cspace, float[] compArray) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        float[] f = new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
        float[] tmp = sourceCS.toCIEXYZ(f);
        float[] tmpout = cspace.fromCIEXYZ(tmp);
        if (compArray != null) {
            System.arraycopy(tmpout, 0, compArray, 0, tmpout.length);
        }
        return compArray == null ? tmpout : compArray;
    }

    private static double[] getCIELab(ColorSpace cspace, int rgb) {
        double[] result = new double[3];
        float[] xyzC = ColorUtil.getColorComponents(rgb, cspace, CIEXYZ_COLOR_SPACE, null);
        double x = xyzC[0] / XYZ_CN[0];
        double y = xyzC[1] / XYZ_CN[1];
        double z = xyzC[2] / XYZ_CN[2];
        double fx = ColorUtil.getFuncCIELab(x);
        double fy = ColorUtil.getFuncCIELab(y);
        double fz = ColorUtil.getFuncCIELab(z);
        result[0] = y > 0.008856 ? 116.0 * Math.pow(y, 0.3333333333333333) - 16.0 : 903.3 * y;
        result[1] = 500.0 * (fx - fy);
        result[2] = 200.0 * (fx - fz);
        return result;
    }

    private static double[] getCIELab(Color c) {
        double[] result = new double[3];
        float[] xyzC = c.getColorComponents(CIEXYZ_COLOR_SPACE, null);
        double x = xyzC[0] / XYZ_CN[0];
        double y = xyzC[1] / XYZ_CN[1];
        double z = xyzC[2] / XYZ_CN[2];
        double fx = ColorUtil.getFuncCIELab(x);
        double fy = ColorUtil.getFuncCIELab(y);
        double fz = ColorUtil.getFuncCIELab(z);
        result[0] = y > 0.008856 ? 116.0 * Math.pow(y, 0.3333333333333333) - 16.0 : 903.3 * y;
        result[1] = 500.0 * (fx - fy);
        result[2] = 200.0 * (fx - fz);
        return result;
    }

    private ColorUtil() {
    }
}

