/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class DataBaseInfo {
    private static final String PROP_ORACLE_USER = "ORACLE_USER";
    private static final String PROP_ORACLE_PWD = "ORACLE_PWD";
    private static final String DB_INFOX_XML_SUBDIR = "/configs/db_infos.xml";

    public static String getJDBC(Properties prop) {
        return DataBaseInfo.getProperty(prop, "JDBC");
    }

    public static String getCentralizedPath(Properties prop) {
        return DataBaseInfo.getProperty(prop, "CENTRALIZED_PATH");
    }

    public static String getName(Properties prop) {
        return DataBaseInfo.getProperty(prop, "NAME");
    }

    public static String getOracleUser(Properties prop) {
        return DataBaseInfo.getProperty(prop, PROP_ORACLE_USER) == null ? DataBaseInfo.getSchema(prop) : DataBaseInfo.getProperty(prop, PROP_ORACLE_USER);
    }

    public static String getOracleUserPwd(Properties prop) {
        return DataBaseInfo.getProperty(prop, PROP_ORACLE_PWD) == null ? DataBaseInfo.getSchema(prop) : DataBaseInfo.getProperty(prop, PROP_ORACLE_PWD);
    }

    public static String getRole(Properties prop) {
        return DataBaseInfo.getProperty(prop, "ROLE");
    }

    public static String getSchema(Properties prop) {
        return DataBaseInfo.getProperty(prop, "SCHEMA");
    }

    public static Properties getDataBaseProperties(String baseDirectory) {
        File dbInfosXML = new File(baseDirectory, DB_INFOX_XML_SUBDIR);
        Properties prop = null;
        if (dbInfosXML.exists()) {
            try (FileInputStream dbInfosXMLInputStream = new FileInputStream(dbInfosXML);){
                prop = new Properties();
                prop.loadFromXML(dbInfosXMLInputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return prop;
    }

    public static boolean saveProperties(File file, Properties prop, String description) {
        try (PrintWriter pw = new PrintWriter(file);){
            prop.keySet().forEach(propName -> pw.println(propName + " = \"" + prop.getProperty(propName.toString()) + "\""));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getCentralizedPath(String baseDirectory) {
        Properties prop = DataBaseInfo.getDataBaseProperties(baseDirectory);
        if (prop == null) {
            return null;
        }
        return DataBaseInfo.getCentralizedPath(prop);
    }

    private static String getProperty(Properties prop, String name) {
        String value = prop.getProperty(name);
        if (value == null) {
            return null;
        }
        if (value.startsWith(">")) {
            value = value.substring(1);
        }
        return StringUtil.removeExtremityChar(value, '\"');
    }

    protected DataBaseInfo() {
    }
}

