/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.StringUtil;
import com.cadwin.basic.misc.ValuesConstants;
import java.io.Serializable;

public class FileSizeRange
implements Serializable {
    private Type type;
    private long minFileSize;
    private long maxFileSize;
    private final String text;

    public FileSizeRange(String text, Type type, long fileSize) {
        this(text, type, fileSize, Long.MIN_VALUE);
    }

    public FileSizeRange(long minFileSize, long maxFileSize) {
        this(null, Type.BETWEEN, minFileSize, maxFileSize);
    }

    public FileSizeRange(Type type) {
        this(null, type.getWithPredefinedValues() ? type : null, type.getWithPredefinedValues() ? type.getMinValue() : Long.MIN_VALUE, type.getWithPredefinedValues() ? type.getMaxValue() : Long.MIN_VALUE);
    }

    public FileSizeRange(String text, Type type, long minFileSize, long maxFileSize) {
        this.text = text;
        this.type = type;
        this.minFileSize = minFileSize;
        this.maxFileSize = maxFileSize;
        if (type == Type.BETWEEN) {
            if (ValuesConstants.isNull(minFileSize) || ValuesConstants.isNull(maxFileSize)) {
                this.type = null;
            }
        } else if (type != Type.FREE_TEXT && ValuesConstants.isNull(minFileSize)) {
            this.type = null;
        }
    }

    public Type getType() {
        return this.type;
    }

    public long getFileSize() {
        return this.minFileSize;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getText() {
        return this.text;
    }

    public static enum Type {
        EMPTY(true, 0L, 0L, "FileSize.Empty"),
        TINY(true, 0L, 10240L, "FileSize.Tiny"),
        SMALL(true, 10240L, 102400L, "FileSize.Small"),
        MEDIUM(true, 102400L, 0x100000L, "FileSize.Medium"),
        LARGE(true, 0x100000L, 0x1000000L, "FileSize.Large"),
        HUGE(true, 0x1000000L, 0x8000000L, "FileSize.Huge"),
        GIGANTIC(true, 0x8000000L, Long.MIN_VALUE, "FileSize.Gigantic"),
        FREE_TEXT(false, Long.MIN_VALUE, Long.MIN_VALUE, null),
        EQUALS(false, Long.MIN_VALUE, Long.MIN_VALUE, null),
        INFERIOR(false, Long.MIN_VALUE, Long.MIN_VALUE, null),
        SUPERIOR(false, Long.MIN_VALUE, Long.MIN_VALUE, null),
        INFERIOR_OR_EQUALS(false, Long.MIN_VALUE, Long.MIN_VALUE, null),
        SUPERIOR_OR_EQUALS(false, Long.MIN_VALUE, Long.MIN_VALUE, null),
        BETWEEN(false, Long.MIN_VALUE, Long.MIN_VALUE, null);

        private boolean withPredefinedValues = false;
        private long minValue = Long.MIN_VALUE;
        private long maxValue = Long.MIN_VALUE;
        private final String dicDescription;

        private Type(boolean withPredefinedValues, long minValue, long maxValue, String dicDescription) {
            this.withPredefinedValues = withPredefinedValues;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.dicDescription = dicDescription;
        }

        public boolean getWithPredefinedValues() {
            return this.withPredefinedValues;
        }

        public long getMinValue() {
            return this.minValue;
        }

        public long getMaxValue() {
            return this.maxValue;
        }

        public String getDicDescription() {
            return this.dicDescription;
        }

        public String getPredefinedValues() {
            if (!this.withPredefinedValues) {
                return null;
            }
            if (this.minValue == this.maxValue) {
                return "(" + StringUtil.fileSizeToString(this.minValue) + ")";
            }
            if (ValuesConstants.isNull(this.maxValue)) {
                return "(>" + StringUtil.fileSizeToString(this.minValue) + ")";
            }
            if (ValuesConstants.isNull(this.minValue)) {
                return "(<" + StringUtil.fileSizeToString(this.maxValue) + ")";
            }
            return "(" + StringUtil.fileSizeToString(this.minValue) + " - " + StringUtil.fileSizeToString(this.maxValue) + ")";
        }
    }
}

