/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class GetInputStream
implements Runnable {
    private final InputStream istr;
    private final StringBuilder buff;
    private String header;
    private String footer;
    private String breakline;

    public GetInputStream(InputStream istr) {
        this.istr = istr;
        this.buff = null;
    }

    public GetInputStream(InputStream istr, String header, String footer, String breakline) {
        this.istr = istr;
        this.header = header;
        this.footer = footer;
        this.breakline = breakline;
        this.buff = new StringBuilder();
    }

    public synchronized boolean isEmpty() {
        return this.buff.length() == 0;
    }

    public synchronized String toString() {
        return this.buff == null ? "" : this.buff.toString();
    }

    @Override
    public void run() {
        boolean done = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.istr));
        try {
            String str;
            while ((str = br.readLine()) != null) {
                if (this.buff == null) {
                    System.out.println(str);
                    continue;
                }
                if (!done) {
                    done = true;
                    this.buff.append(this.header);
                }
                this.buff.append(str).append(this.breakline);
            }
        }
        catch (IOException io) {
            if (this.buff == null) {
                io.printStackTrace();
            }
            this.buff.append(io.getMessage());
        }
        if (this.buff != null && done) {
            this.buff.append(this.footer);
        }
    }
}

