/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Stream;

public class LocaleUtil {
    private static final Map<String, Locale> PREDEFINED_LOCALE_MAP = new HashMap<String, Locale>();
    public static final Comparator<Locale> COMPARATOR;

    public static boolean isRFC1766(String lang) {
        StringTokenizer tk = new StringTokenizer(lang, "-_");
        String language = tk.hasMoreTokens() ? tk.nextToken() : "";
        String country = tk.hasMoreTokens() ? tk.nextToken() : "";
        return language.length() <= 2 && country.length() <= 2;
    }

    public static Locale toLocale(String lang) {
        Locale result;
        if (lang == null) {
            result = null;
        } else {
            int firstIndexOfComma = lang.indexOf(44);
            String safeLang = firstIndexOfComma == -1 ? lang : lang.substring(0, firstIndexOfComma);
            Locale predefinedLocale = PREDEFINED_LOCALE_MAP.get(safeLang.toLowerCase());
            if (predefinedLocale == null) {
                StringTokenizer tk = new StringTokenizer(safeLang, "-_");
                String language = tk.hasMoreTokens() ? tk.nextToken() : "";
                String country = tk.hasMoreTokens() ? tk.nextToken() : "";
                String variant = tk.hasMoreTokens() ? tk.nextToken() : "";
                result = Arrays.stream(Locale.getAvailableLocales()).filter(currentLocale -> currentLocale.getLanguage().equalsIgnoreCase(language) && currentLocale.getCountry().equalsIgnoreCase(country) && currentLocale.getVariant().equalsIgnoreCase(variant)).findFirst().orElse(Arrays.stream(Locale.getAvailableLocales()).filter(currentLocale -> currentLocale.getLanguage().equalsIgnoreCase(language) && currentLocale.getCountry().equalsIgnoreCase(country)).findFirst().orElse(Arrays.stream(Locale.getAvailableLocales()).filter(currentLocale -> currentLocale.getLanguage().equalsIgnoreCase(language)).findFirst().orElse(new Locale(language, country, variant))));
            } else {
                result = predefinedLocale;
            }
        }
        return result;
    }

    public static String toLang(Locale locale) {
        return LocaleUtil.toXmlString(locale).toLowerCase();
    }

    public static String toXmlString(Locale locale) {
        return locale.toString().replace('_', '-');
    }

    public static boolean isCompatible(Locale test, Locale ref) {
        if (test == null || ref == null) {
            return false;
        }
        if (test.equals(ref)) {
            return true;
        }
        if (test.getLanguage().equals(ref.getLanguage())) {
            return true;
        }
        String refCountry = ref.getCountry();
        if (refCountry.length() > 0 && test.getCountry().equals(refCountry)) {
            return true;
        }
        String refVariant = ref.getVariant();
        return refVariant.length() > 0 && test.getVariant().equals(refVariant);
    }

    public static final Comparator<Locale> getLocaleComparator(Locale locale) {
        return (locale0, locale1) -> {
            int result = locale0.getLanguage().equals(locale1.getLanguage()) ? (locale0.getCountry().equals(locale1.getCountry()) ? (locale0.getVariant().equals(locale1.getVariant()) ? 0 : (locale0.getVariant().isEmpty() ? -1 : (locale1.getVariant().isEmpty() ? 1 : locale0.getVariant().compareTo(locale1.getVariant())))) : (locale0.getCountry().isEmpty() ? -1 : (locale1.getCountry().isEmpty() ? 1 : locale0.getCountry().compareTo(locale1.getCountry())))) : (locale0.getLanguage().equals(locale.getLanguage()) ? -1 : (locale1.getLanguage().equals(locale.getLanguage()) ? 1 : (locale0.getLanguage().equals(Locale.ENGLISH.getLanguage()) ? -1 : (locale1.getLanguage().equals(Locale.ENGLISH.getLanguage()) ? 1 : locale0.getLanguage().compareTo(locale1.getLanguage())))));
            return result;
        };
    }

    private LocaleUtil() {
    }

    static {
        Stream.of(Locale.ENGLISH, Locale.FRENCH, Locale.FRANCE, new Locale("nl"), new Locale("es"), new Locale("pt"), new Locale("ru"), new Locale("ro"), new Locale("es", "MX"), Locale.ITALIAN, Locale.JAPANESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.KOREAN, Locale.SIMPLIFIED_CHINESE).forEachOrdered(locale -> PREDEFINED_LOCALE_MAP.put(locale.toString().toLowerCase(), (Locale)locale));
        COMPARATOR = (locale0, locale1) -> {
            int result = locale0.getLanguage().equals(locale1.getLanguage()) ? (locale0.getCountry().equals(locale1.getCountry()) ? (locale0.getVariant().equals(locale1.getVariant()) ? 0 : (locale0.getVariant().isEmpty() ? -1 : (locale1.getVariant().isEmpty() ? 1 : locale0.getVariant().compareTo(locale1.getVariant())))) : (locale0.getCountry().isEmpty() ? -1 : (locale1.getCountry().isEmpty() ? 1 : locale0.getCountry().compareTo(locale1.getCountry())))) : locale0.getLanguage().compareTo(locale1.getLanguage());
            return result;
        };
    }
}

