/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.LineNumberReaderIF;
import com.cadwin.basic.misc.StringUtil;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public class SkipAdaCommentsLineReader
extends LineNumberReader
implements LineNumberReaderIF {
    private String cachedLine = null;
    private boolean removeAllWhitespace;

    public SkipAdaCommentsLineReader(Reader read, boolean removeAllWhitespace) {
        super(read);
        this.removeAllWhitespace = removeAllWhitespace;
    }

    public SkipAdaCommentsLineReader(Reader read) throws IOException {
        this(read, false);
    }

    @Override
    public String readLine() throws IOException {
        String line = this.cachedLine;
        this.cachedLine = null;
        if (line == null) {
            line = this.myReadLine();
        }
        return line;
    }

    private String myReadLine() throws IOException {
        String line = super.readLine();
        if (line != null) {
            line = StringUtil.removeAdaComments(line);
            if (this.removeAllWhitespace) {
                line = StringUtil.removeAllWhitespace(line);
            }
        }
        return line;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.cachedLine != null) {
            return true;
        }
        if (super.ready()) {
            this.cachedLine = this.myReadLine();
            if (this.cachedLine == null) {
                return false;
            }
            if (this.cachedLine.length() == 0) {
                this.cachedLine = null;
                return this.ready();
            }
            return true;
        }
        return false;
    }
}

