/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class StringReplacement {
    private static final boolean DEBUG_MODE = false;
    private String text;
    private String[] tokens;
    private int[] replaceInsertPlaces;
    private String[] values;

    public static String replace(String text, Map<String, Object> parameters) {
        return StringReplacement.replace(text, parameters, false);
    }

    public static String replace(String text, Map<String, Object> parameters, boolean toLowerCase) {
        if (parameters == null || text == null) {
            return text;
        }
        StringReplacement rep = new StringReplacement(text);
        for (int no = 0; no < rep.countTokens(); ++no) {
            String token = toLowerCase ? rep.getToken(no).toLowerCase() : rep.getToken(no);
            boolean quoted = token.startsWith("'");
            boolean doubleQuoted = token.startsWith("\"");
            token = quoted ? StringUtil.removeSimpleQuote(token) : token;
            String string = token = doubleQuoted ? StringUtil.removeQuote(token) : token;
            if (!parameters.containsKey(token)) continue;
            String value = Objects.toString(parameters.get(token), "");
            if (quoted) {
                rep.setValue(no, StringUtil.simpleQuoteString(StringUtil.toSqlString(value)));
                continue;
            }
            if (doubleQuoted) {
                rep.setValue(no, StringUtil.quoteString(StringUtil.toQuotedString(value)));
                continue;
            }
            rep.setValue(no, value);
        }
        return rep.getReplacedText();
    }

    public StringReplacement(String text) {
        this(text, "%");
    }

    public StringReplacement(String text, String delimiters) {
        int i;
        int start = 0;
        int startTokens = -1;
        ArrayList<String> tokList = new ArrayList<String>();
        ArrayList<Integer> repList = new ArrayList<Integer>();
        StringBuilder buff = new StringBuilder();
        char maxDelimChar = this.getMaxDelimChar(delimiters);
        for (i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c <= maxDelimChar && delimiters.indexOf(c) >= 0) {
                if (startTokens >= 0) {
                    tokList.add(text.substring(startTokens + 1, i));
                    buff.append(text.substring(start, startTokens));
                    repList.add(buff.length());
                    start = i + 1;
                    startTokens = -1;
                    continue;
                }
                startTokens = i;
                continue;
            }
            if (this.isTokenChar(c)) continue;
            startTokens = -1;
        }
        buff.append(text.substring(start));
        this.text = buff.toString();
        this.tokens = new String[tokList.size()];
        tokList.toArray(this.tokens);
        this.values = new String[this.tokens.length];
        this.replaceInsertPlaces = new int[repList.size()];
        for (i = 0; i < this.replaceInsertPlaces.length; ++i) {
            this.replaceInsertPlaces[i] = (Integer)repList.get(i);
        }
    }

    private char getMaxDelimChar(String delimiters) {
        if (delimiters == null) {
            return '\u0000';
        }
        char m = '\u0000';
        for (int i = 0; i < delimiters.length(); ++i) {
            char c = delimiters.charAt(i);
            if (m >= c) continue;
            m = c;
        }
        return m;
    }

    private boolean isTokenChar(char c) {
        return c == '\"' || c == '\'' || c == '_' || c == '#' || c == '.' || c == ':' || Character.isDigit(c) || Character.isLetter(c);
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public int countTokens() {
        return this.tokens.length;
    }

    public String getToken(int id) {
        return this.tokens[id];
    }

    public void resetAllValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    public void setValue(int id, String value) {
        this.values[id] = value;
    }

    public String getReplacedText() {
        StringBuilder buff = new StringBuilder(this.text);
        for (int i = this.tokens.length - 1; i >= 0; --i) {
            if (this.values[i] != null) {
                buff.insert(this.replaceInsertPlaces[i], this.values[i]);
                continue;
            }
            buff.insert(this.replaceInsertPlaces[i], '%');
            buff.insert(this.replaceInsertPlaces[i], this.tokens[i]);
            buff.insert(this.replaceInsertPlaces[i], '%');
        }
        return buff.toString();
    }
}

