/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.ColorUtil;
import com.cadwin.basic.misc.DurationWithTimeUse;
import com.cadwin.basic.misc.ValuesConstants;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class StringUtil {
    private static final String[] XML_KNOWN_ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};
    private static final Pattern NO_ASCII_PATTERN = Pattern.compile("[^\\p{ASCII}]");
    private static final Pattern I_TRIM_PATTERN = Pattern.compile("\\b\\s{2,}\\b");

    public static String ellipse(String str, int length) {
        if (str == null) {
            return "";
        }
        if (length > 0 && str.length() > length) {
            return str.substring(0, length) + "...";
        }
        return str;
    }

    public static String fixedSizeString(String str, int length) {
        if (str == null) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (int i = str.length(); i < length; ++i) {
            buff.append(' ');
        }
        buff.append(str);
        return buff.toString();
    }

    public static String durationToString(long durationInMillis) {
        return StringUtil.durationToString(durationInMillis, 3);
    }

    public static String durationToStringAft0(long durationInMillis) {
        return StringUtil.durationToString(durationInMillis, 0);
    }

    public static String durationToStringAft1(long durationInMillis) {
        return StringUtil.durationToString(durationInMillis, 1);
    }

    public static String durationToStringAft2(long durationInMillis) {
        return StringUtil.durationToString(durationInMillis, 2);
    }

    private static String durationToString(long durationInMillis, int aft) {
        long absDurationInMillis = Math.abs(durationInMillis);
        long minuteCount = TimeUnit.MILLISECONDS.toMinutes(absDurationInMillis);
        long milliSecondCountOfMinutes = TimeUnit.MINUTES.toMillis(minuteCount);
        long remainingSecondsInMillis = absDurationInMillis - milliSecondCountOfMinutes;
        long secondCount = TimeUnit.MILLISECONDS.toSeconds(remainingSecondsInMillis);
        StringBuilder builder = new StringBuilder();
        if (minuteCount > 0L) {
            builder.append(minuteCount).append(" m ");
        }
        switch (aft) {
            case 0: {
                builder.append((remainingSecondsInMillis + 500L) / 1000L);
                break;
            }
            case 1: {
                builder.append(secondCount);
                long tenths = (remainingSecondsInMillis - TimeUnit.SECONDS.toMillis(secondCount) + 50L) / 100L;
                builder.append(".").append(Long.toString(10L + tenths).substring(1));
                break;
            }
            case 2: {
                builder.append(secondCount);
                long hundredths = (remainingSecondsInMillis - TimeUnit.SECONDS.toMillis(secondCount) + 5L) / 10L;
                builder.append(".").append(Long.toString(100L + hundredths).substring(1));
                break;
            }
            case 3: {
                builder.append(secondCount);
                long milliSecondCount = remainingSecondsInMillis - TimeUnit.SECONDS.toMillis(secondCount);
                builder.append(".").append(Long.toString(1000L + milliSecondCount).substring(1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected aft value : " + aft);
            }
        }
        builder.append(" s");
        return builder.toString();
    }

    public static String getRelativeTimeSpanString(long duration) {
        DurationWithTimeUse durationWithTime = DurationWithTimeUse.getDurationWithTimeBetweenNowAnd(duration);
        return DicJavaAgo.getBestValue(durationWithTime, duration).getDictionnnaryValue();
    }

    public static String fileSizeToString(long fileSize) {
        String result;
        if (fileSize == Long.MIN_VALUE) {
            result = null;
        } else {
            String subResult = fileSize < 1024L ? fileSize + " " : (fileSize < 1048575L ? (fileSize + 1023L) / 1024L + " K" : (fileSize < 0x3FFFFFFFL ? fileSize / 0x100000L + " M" : (fileSize < 0xFFFFFFFFFFL ? fileSize / 0x40000000L + " G" : fileSize / 0x10000000000L + " T")));
            Locale locale = Locale.getDefault();
            boolean frenchCompatible = locale.getLanguage().equals(new Locale("fr", "", "").getLanguage());
            result = subResult + (frenchCompatible ? "o" : "B");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getBoolean(String value) {
        if (value == null) return false;
        if (!Stream.of(Boolean.TRUE.toString(), "t", "1").anyMatch(value::equalsIgnoreCase)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getBooleanTrueIsDefault(String value) {
        if (value == null) return true;
        if (!Stream.of(Boolean.FALSE.toString(), "f", "0").noneMatch(value::equalsIgnoreCase)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBoolean(String value) {
        if (value == null) return false;
        if (value.isBlank()) return false;
        if (!Stream.of(Boolean.FALSE.toString(), "f", "0", Boolean.TRUE.toString(), "t", "1").anyMatch(value::equalsIgnoreCase)) return false;
        return true;
    }

    public static String capitalize(String s) {
        StringBuilder n = new StringBuilder();
        boolean capitalize = true;
        for (int i = 0; i < s.length(); ++i) {
            n.append(capitalize ? Character.toUpperCase(s.charAt(i)) : Character.toLowerCase(s.charAt(i)));
            capitalize = false;
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            capitalize = true;
        }
        return n.toString();
    }

    public static String capitalizeAfterDigit(String s) {
        StringBuilder n = new StringBuilder();
        boolean capitalize = true;
        for (int i = 0; i < s.length(); ++i) {
            n.append(capitalize ? Character.toUpperCase(s.charAt(i)) : Character.toLowerCase(s.charAt(i)));
            capitalize = false;
            if (Character.isLetter(s.charAt(i))) continue;
            capitalize = true;
        }
        return n.toString();
    }

    public static String format(String pattern, Object ... arguments) {
        if (pattern.contains("%s")) {
            try (Formatter formatter = new Formatter();){
                String string = formatter.format(pattern, arguments).toString();
                return string;
            }
        }
        return MessageFormat.format(pattern.replace("'", "''"), arguments);
    }

    public static String replace(String s, char search, String replace) {
        return s.replace(Character.toString(search), replace);
    }

    public static String replace(String s, String search, String replace) {
        return StringUtil.replace(s, search, replace, true);
    }

    public static String replaceIgnoreCase(String s, String search, String replace) {
        return StringUtil.replace(s, search, replace, false);
    }

    private static String replace(String s, String search, String replace, boolean caseSensitive) {
        String result = caseSensitive ? s.replace(search, replace) : Pattern.compile(search, 82).matcher(s).replaceAll(Matcher.quoteReplacement(replace));
        return result;
    }

    public static String replace(String source, CharSequence[] target, CharSequence[] replacement) {
        String result = source;
        for (int targetIndex = 0; targetIndex < target.length; ++targetIndex) {
            result = result.replace(target[targetIndex], replacement[targetIndex]);
        }
        return result;
    }

    public static boolean containsIgnoreCase(String line, String s) {
        return line.toLowerCase().contains(s.toLowerCase());
    }

    public static boolean startsWithIgnoreCase(String line, String prefix) {
        return line.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String line, String suffix) {
        return line.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static String toSqlString(String str) {
        int length = str.length();
        StringBuilder ret = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            ret.append(c);
            if (c != '\'') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String toQuotedString(String str) {
        int length = str.length();
        StringBuilder ret = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            ret.append(c);
            if (c != '\"') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String utf8ToString(String buff) {
        byte[] bytes = new byte[buff.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)buff.charAt(i);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String simpleQuoteString(String str) {
        return "'" + str + "'";
    }

    public static String quoteString(String str) {
        return "\"" + str + "\"";
    }

    public static String removeExtremityChar(String line, char c) {
        boolean bottomChar;
        if (line == null || line.length() < 2) {
            return line;
        }
        int first = 0;
        int last = line.length();
        boolean headChar = line.charAt(first) == c;
        boolean bl = bottomChar = line.charAt(last - 1) == c;
        if (headChar) {
            ++first;
        }
        if (bottomChar) {
            --last;
        }
        return line.substring(first, last);
    }

    public static String removeQuote(String line) {
        return StringUtil.removeExtremityChar(line, '\"');
    }

    public static String removeSimpleQuote(String line) {
        return StringUtil.removeExtremityChar(line, '\'');
    }

    public static boolean isInListIgnoreCase(String search, String[] list) {
        if (list == null) {
            return false;
        }
        for (String token : list) {
            if (!token.equalsIgnoreCase(search)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInList(String search, String[] list) {
        for (String token : list) {
            if (!token.equals(search)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String search, String[] list) {
        for (String token : list) {
            if (!search.contains(token)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfIgnoreCase(String search, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equalsIgnoreCase(search)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String search, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(search)) continue;
            return i;
        }
        return -1;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            pw.flush();
        }
        return sw.toString();
    }

    public static String[] toArray(List<?> list) {
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            ret[i] = o == null ? null : o.toString();
        }
        return ret;
    }

    public static String removeAllWhitespace(String line) {
        if (line == null) {
            return null;
        }
        boolean inQuot = false;
        int l = line.length();
        StringBuilder ret = new StringBuilder(l);
        for (int i = 0; i < l; ++i) {
            if (line.charAt(i) == '\"') {
                boolean bl = inQuot = !inQuot;
            }
            if (!inQuot && Character.isWhitespace(line.charAt(i))) continue;
            ret.append(line.charAt(i));
        }
        return ret.toString();
    }

    public static int getAdaCommentsIndex(String line) {
        boolean inQuot = false;
        boolean isMinus = false;
        int l = line.length();
        for (int i = 0; i < l; ++i) {
            if (line.charAt(i) == '\"') {
                boolean bl = inQuot = !inQuot;
            }
            if (!inQuot) {
                if (line.charAt(i) == '-') {
                    if (isMinus) {
                        return i - 1;
                    }
                    isMinus = true;
                    continue;
                }
                isMinus = false;
                continue;
            }
            isMinus = false;
        }
        return -1;
    }

    public static String removeAdaComments(String line) {
        int commentIndex = StringUtil.getAdaCommentsIndex(line);
        String lineWithoutAdaComments = commentIndex != -1 ? line.substring(0, commentIndex) : line;
        return lineWithoutAdaComments;
    }

    public static String[] tokenize(String line) {
        StringTokenizer tk = new StringTokenizer(line, "=");
        String token = tk.hasMoreElements() ? tk.nextToken() : null;
        String value = null;
        if (token != null) {
            value = line.length() > token.length() + 1 && line.charAt(token.length() + 1) == '>' ? (line.length() > token.length() + 2 ? StringUtil.removeQuote(line.substring(token.length() + 2)) : "") : (line.length() > token.length() + 1 ? StringUtil.removeQuote(line.substring(token.length() + 1)) : "");
        }
        return new String[]{token, value};
    }

    public static String getJavaInfos() {
        return "Java " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + " Class version " + System.getProperty("java.class.version");
    }

    public static String encodeForUrl(String url) {
        String delims = ":/\\ ";
        StringBuilder buff = new StringBuilder(url.length() * 2);
        StringTokenizer tk = new StringTokenizer(url, ":/\\ ", true);
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (":/\\ ".contains(token)) {
                buff.append(token.replace('\\', '/'));
                continue;
            }
            buff.append(StringUtil.utf8Encode(token));
        }
        return buff.toString().replace(" ", "%20");
    }

    public static String utf8Encode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    public static String iso8859Encode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.ISO_8859_1.name());
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    public static String toJavaString(String value) {
        StringBuilder buff = new StringBuilder();
        char[] chars = value.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\"': {
                    buff.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block4;
                }
                default: {
                    buff.append(chars[i]);
                }
            }
        }
        return buff.toString();
    }

    public static String utf8Decode(String text) {
        try {
            return URLDecoder.decode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    public static String toHTMLString(String in) {
        return StringUtil.toHTMLString(in, false);
    }

    public static String toHTMLString(String in, boolean allSpaceNonBreakable) {
        StringBuilder out = new StringBuilder();
        boolean lastWasSpace = false;
        block7: for (int i = 0; in != null && i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Character.isSpaceChar(c)) {
                if (allSpaceNonBreakable || lastWasSpace) {
                    out.append("&nbsp;");
                } else {
                    out.append(' ');
                }
                lastWasSpace = true;
                continue;
            }
            lastWasSpace = false;
            switch (c) {
                case '\'': {
                    out.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    out.append("&#34;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String toXmlText(String value) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    int nextSemi = value.indexOf(59, i);
                    if (nextSemi < 0 || !StringUtil.isXmlReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block5;
                    }
                    sb.append('&');
                    continue block5;
                }
                default: {
                    if (!StringUtil.isXmlLegalCharacter(c)) continue block5;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String toXmlAttr(String value) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                case '&': {
                    int nextSemi = value.indexOf(59, i);
                    if (nextSemi < 0 || !StringUtil.isXmlReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block6;
                    }
                    sb.append('&');
                    continue block6;
                }
                default: {
                    if (!StringUtil.isXmlLegalCharacter(c)) continue block6;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isXmlReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        for (String xmlKnownEntity : XML_KNOWN_ENTITIES) {
            if (!name.equals(xmlKnownEntity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isXmlLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }

    public static String ltrim(String str) {
        return str == null ? null : str.stripLeading();
    }

    public static String rtrim(String str) {
        return str == null ? null : str.stripTrailing();
    }

    public static String itrim(String str) {
        return str == null ? null : I_TRIM_PATTERN.matcher(str).replaceAll(" ");
    }

    public static String trim(String str) {
        return str == null ? null : StringUtil.itrim(str.strip());
    }

    public static String rot13(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder tempReturn = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            int cap;
            int abyte = in.charAt(i);
            abyte = ((abyte &= ~(cap = abyte & 0x20)) >= 65 && abyte <= 90 ? (abyte - 65 + 13) % 26 + 65 : abyte) | cap;
            tempReturn.append((char)abyte);
        }
        return tempReturn.toString();
    }

    public static String getTimeMarker() {
        return StringUtil.getTimeMarker('-');
    }

    public static String getTimeMarker(char sep) {
        return new SimpleDateFormat("yyyyMMdd" + sep + "HHmmss").format(new Date());
    }

    public static String beforeThis(String value, char mark) {
        String result;
        if (value == null) {
            result = null;
        } else {
            int idx = value.indexOf(mark);
            result = value.substring(0, idx);
        }
        return result;
    }

    public static String afterThis(String value, char mark) {
        String result;
        if (value == null) {
            result = null;
        } else {
            int idx = value.indexOf(mark);
            result = value.substring(idx + 1);
        }
        return result;
    }

    public static String cleanForFileNameUse(String name) {
        return name == null ? null : name.replaceAll("[:\\\\/*?\"<>|]", "_");
    }

    public static String cleanForPathNameUse(String name) {
        return name == null ? null : name.replaceAll("[:*?\"<>|]", "_");
    }

    public static Properties getLinkedResource(Class<?> c) throws IOException {
        return StringUtil.getLinkedResource(c, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getLinkedResource(Class<?> c, String suffix) throws IOException {
        Properties linkedResource = new Properties();
        String name = c.getName().replace('.', '/') + (suffix != null ? suffix : "") + ".xml";
        InputStream is = c.getClassLoader().getResourceAsStream(name);
        if (is != null) {
            linkedResource = new Properties();
            try {
                linkedResource.loadFromXML(is);
            }
            finally {
                is.close();
            }
        }
        return linkedResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getLinkedResource(Class<?> c, String rname, String suffix) throws IOException {
        Properties linkedResource = new Properties();
        String name = c.getPackage().getName().replace('.', '/') + "/" + rname + (suffix != null ? suffix : "") + ".xml";
        InputStream is = c.getClassLoader().getResourceAsStream(name);
        if (is != null) {
            linkedResource = new Properties();
            try {
                linkedResource.loadFromXML(is);
            }
            finally {
                is.close();
            }
        }
        return linkedResource;
    }

    public static String removeAccent(String str) {
        return str == null ? null : NO_ASCII_PATTERN.matcher(Normalizer.normalize(str, Normalizer.Form.NFD)).replaceAll("");
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isStringOutLimit(String text, Charset charset, int limit) {
        if (text == null) {
            return false;
        }
        byte[] bs = text.getBytes(charset);
        return limit > 0 && bs.length > limit;
    }

    public static boolean isUTF8StringOutLimit(String text, int limit) {
        return StringUtil.isStringOutLimit(text, StandardCharsets.UTF_8, limit);
    }

    public static String truncate(String par, int length) {
        String value = par;
        if (value != null && value.length() > length) {
            value = value.substring(0, length);
        }
        return value;
    }

    public static <T extends Enum<?>> T toEnum(Class<T> enumType, String value, T dflt) {
        for (Enum c : (Enum[])enumType.getEnumConstants()) {
            if (!c.name().equalsIgnoreCase(value)) continue;
            return (T)c;
        }
        return dflt;
    }

    public static String trimOrNullifyIfEmpty(String string) {
        return Optional.ofNullable(string).map(String::trim).filter(Predicate.not(String::isEmpty)).orElse(null);
    }

    public static String getHTMLText(String text, Color color) {
        return StringUtil.getHTMLText(text, null, color, false, true);
    }

    public static String getHTMLText(String text, Color backcolor, Color forecolor) {
        return StringUtil.getHTMLText(text, backcolor, forecolor, false, true);
    }

    public static String getHTMLTextBold(String text, Color color) {
        return StringUtil.getHTMLText(text, null, color, true, true);
    }

    public static String getHTMLTextBold(String text, Color backcolor, Color forecolor) {
        return StringUtil.getHTMLText(text, backcolor, forecolor, true, true);
    }

    public static String getHTMLText(String text, Color backcolor, Color forecolor, boolean bold, boolean withHtmlTag) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(withHtmlTag ? "<html>" : "");
        if (withHtmlTag && backcolor != null) {
            sb.append("<body bgcolor=\"").append(ColorUtil.getHtmlColor(backcolor)).append("\">");
        }
        sb.append(bold ? "<b>" : "").append("<font color=\"").append(ColorUtil.getHtmlColor(forecolor)).append("\">").append(text).append("</font>").append(bold ? "</b>" : "");
        if (withHtmlTag && backcolor != null) {
            sb.append("</body>");
        }
        sb.append(withHtmlTag ? "</html>" : "");
        return sb.toString();
    }

    public static String getHTMLTextWithLabel(String label, Color labelColor, String text, Color textColor) {
        if ((label == null || label.isEmpty()) && (text == null || text.isEmpty())) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(StringUtil.getHTMLText(label, null, labelColor, true, false)).append(" ").append(StringUtil.getHTMLText(text, null, textColor, false, false));
        sb.append("</html>");
        return sb.toString();
    }

    public static String getHTMLTextWithLabel(Color backcolor, String label, Color labelColor, String text, Color textColor) {
        if ((label == null || label.isEmpty()) && (text == null || text.isEmpty())) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<html>");
        if (backcolor != null) {
            sb.append("<body bgcolor=\"").append(ColorUtil.getHtmlColor(backcolor)).append("\">");
        }
        sb.append(StringUtil.getHTMLText(label, null, labelColor, true, false)).append(" ").append(StringUtil.getHTMLText(text, null, textColor, false, false));
        if (backcolor != null) {
            sb.append("</body>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static String getStyledText(String text, int size, Color backcolor, Color forecolor, boolean bold, boolean italic, boolean underline, boolean strikeThrough) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<style");
        if (!ValuesConstants.isNull(size)) {
            sb.append(" size=\"").append(size).append("\"");
        }
        if (backcolor != null) {
            sb.append(" backcolor=\"").append(ColorUtil.getHtmlColor(backcolor)).append("\"");
        }
        if (forecolor != null) {
            sb.append(" forecolor=\"").append(ColorUtil.getHtmlColor(forecolor)).append("\"");
        }
        sb.append(bold ? " isBold=\"true\"" : "");
        sb.append(italic ? " isItalic=\"true\"" : "");
        sb.append(underline ? " isUnderline=\"true\"" : "");
        sb.append(strikeThrough ? " isStrikeThrough=\"true\"" : "");
        sb.append(">").append(text).append("</style>");
        return sb.toString();
    }

    public static String getStyledText(String text, Color backcolor, Color forecolor, boolean bold, boolean italic, boolean underline, boolean strikeThrough) {
        return StringUtil.getStyledText(text, Integer.MIN_VALUE, backcolor, forecolor, bold, italic, underline, strikeThrough);
    }

    public static String getStyledText(String text, Color color) {
        return StringUtil.getStyledText(text, Integer.MIN_VALUE, null, color, false, false, false, false);
    }

    public static String getStyledTextBold(String text, Color color) {
        return StringUtil.getStyledText(text, Integer.MIN_VALUE, null, color, true, false, false, false);
    }

    public static String getStyledTextWithLabel(String label, Color labelColor, String text, Color textColor) {
        if ((label == null || label.isEmpty()) && (text == null || text.isEmpty())) {
            return "";
        }
        return StringUtil.getStyledText(label, Integer.MIN_VALUE, null, labelColor, true, false, false, false) + " " + (text == null ? "" : StringUtil.getStyledText(text, Integer.MIN_VALUE, null, textColor, false, false, false, false));
    }

    public static String nullifyIfBlank(String string) {
        return Optional.ofNullable(string).filter(Predicate.not(String::isBlank)).orElse(null);
    }

    private static enum DicJavaAgo {
        TODAY("dic_today"),
        YESTERDAY("dic_java_yesterday"),
        THIS_WEEK("dic_java_this_week"),
        LAST_WEEK("dic_java_last_week"),
        TWO_WEEKS_AGO("dic_java_there_are_two_weeks"),
        THIS_MONTH("dic_java_this_month"),
        LAST_MONTH("dic_java_last_month"),
        TWO_MONTH_AGO("dic_java_there_are_two_months"),
        LAST_SIX_MONTHS("dic_java_last_6_months"),
        THIS_YEAR("dic_java_in_the_year"),
        LAST_YEAR("dic_java_last_year"),
        TWO_YEARS_AGO("dic_java_there_are_two_years"),
        BETWEEN_THREE_AND_TEN_YEARS("dic_java_between_three_and_ten_years"),
        SINCE_THE_BEGINING_OF_TIME("dic_java_since_the_beginning");

        private final String dictionnnaryValue;

        private DicJavaAgo(String dicValue) {
            this.dictionnnaryValue = dicValue;
        }

        String getDictionnnaryValue() {
            return this.dictionnnaryValue;
        }

        private static DicJavaAgo getBestValue(DurationWithTimeUse param, long duration) {
            if (param.getPeriodBetween().getYears() > 10) {
                return SINCE_THE_BEGINING_OF_TIME;
            }
            if (param.getPeriodBetween().getYears() <= 10 && param.getPeriodBetween().getYears() >= 3) {
                return BETWEEN_THREE_AND_TEN_YEARS;
            }
            if (param.getPeriodBetween().getYears() == 2) {
                return TWO_YEARS_AGO;
            }
            if (param.getPeriodBetween().getYears() == 1) {
                return LAST_YEAR;
            }
            if (param.getPeriodBetween().getMonths() > 7) {
                return THIS_YEAR;
            }
            if (param.getPeriodBetween().getMonths() > 2) {
                return LAST_SIX_MONTHS;
            }
            if (param.getPeriodBetween().getMonths() > 1) {
                return TWO_MONTH_AGO;
            }
            if (param.getPeriodBetween().getMonths() == 1) {
                return THIS_MONTH;
            }
            Calendar todayCalendar = Calendar.getInstance();
            Calendar referenceCalendar = Calendar.getInstance();
            referenceCalendar.setTimeInMillis(duration);
            int weekNumber = todayCalendar.get(3);
            int refWeekNumber = referenceCalendar.get(3);
            int weekDiff = weekNumber - refWeekNumber;
            if (param.getPeriodBetween().getDays() > 1 && weekDiff > 1) {
                return TWO_WEEKS_AGO;
            }
            if (param.getPeriodBetween().getDays() > 1 && weekDiff == 1) {
                return LAST_WEEK;
            }
            if (param.getPeriodBetween().getDays() > 1 && weekDiff == 0) {
                return THIS_WEEK;
            }
            if (param.getPeriodBetween().getDays() == 1) {
                return YESTERDAY;
            }
            return TODAY;
        }
    }
}

