/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.StringUtil;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Version {
    private int[] versions;
    private String[] versionsDisplay;
    private String[] variants;

    private static int tranformLetterToNumber(String text) {
        int val = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(text.length() - 1 - i);
            val += c * (int)Math.pow(123.0, i);
        }
        return val;
    }

    private static int countDelimiters(String s, char delimiter) {
        int nb = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (delimiter != s.charAt(i)) continue;
            ++nb;
        }
        return nb;
    }

    public Version() {
    }

    public Version(String version) {
        this.setVersion(version);
    }

    public Version(String majorVersion, String minorVersionAndVariant) {
        this.setVersion(majorVersion, minorVersionAndVariant);
    }

    public Version(int majorVersion, int minorVersion) {
        this.setVersion(majorVersion, minorVersion);
    }

    public Version(int majorVersion) {
        int[] v = new int[]{majorVersion};
        this.versions = v;
    }

    public Version(int[] versions) {
        this.versions = versions;
    }

    public Version(int[] versions, String[] variants) {
        this.versions = versions;
        this.variants = variants;
    }

    public boolean isNull() {
        return this.getMajorVersion() == -1;
    }

    protected final void setVersion(String version) {
        if (version == null) {
            return;
        }
        try {
            String ver = StringUtil.replace(version, '_', "");
            int lim = ver.indexOf(46);
            int nbPoints = Version.countDelimiters(ver, '.');
            this.versions = new int[nbPoints + 1];
            this.versionsDisplay = new String[nbPoints + 1];
            this.versions[0] = Integer.parseInt(lim < 0 ? ver : ver.substring(0, lim));
            for (int depth = 1; depth <= nbPoints; ++depth) {
                int nextPoint = ver.indexOf(46, lim + 1);
                if (nextPoint < 0) {
                    int variant = ver.indexOf(45, lim + 1);
                    nextPoint = variant >= 0 ? variant : ver.length();
                }
                try {
                    this.versions[depth] = Integer.parseInt(ver.substring(lim + 1, nextPoint));
                }
                catch (NumberFormatException e) {
                    this.versionsDisplay[depth] = ver.substring(lim + 1, nextPoint);
                    this.versions[depth] = Version.tranformLetterToNumber(ver.substring(lim + 1, nextPoint));
                }
                lim = nextPoint;
            }
            if (lim > 0 && lim < ver.length()) {
                int nbVariants = Version.countDelimiters(ver.substring(lim), '-');
                this.variants = new String[nbVariants];
                for (int depth = 0; depth < nbVariants; ++depth) {
                    int nextVariant = ver.indexOf(45, lim + 1);
                    if (nextVariant < 0) {
                        nextVariant = ver.length();
                    }
                    this.variants[depth] = ver.substring(lim + 1, nextVariant);
                    lim = nextVariant;
                }
            }
        }
        catch (NumberFormatException e) {
            this.versions = null;
            this.variants = null;
        }
    }

    protected final void setVersion(String majorVersion, String minorVersionAndVariant) {
        try {
            int majorV = Integer.parseInt(majorVersion);
            String minorVersion = minorVersionAndVariant;
            String variant = null;
            Pattern p = Pattern.compile("(\\d*)(\\D.*)");
            Matcher m = p.matcher(minorVersionAndVariant);
            if (m.matches()) {
                minorVersion = m.group(1);
                variant = m.group(2);
            }
            int minorV = Integer.parseInt(minorVersion);
            int[] v = new int[]{majorV, minorV};
            this.versions = v;
            if (variant != null) {
                this.variants = new String[]{variant};
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected final void setVersion(int majorVersion, int minorVersion) {
        int[] v = new int[]{majorVersion, minorVersion};
        this.versions = v;
    }

    public int getMajorVersion() {
        return this.getVersion(0);
    }

    public int getVersion(int depth) {
        return this.versions != null && this.versions.length > depth ? this.versions[depth] : -1;
    }

    public String[] getVariants() {
        return this.variants;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Arrays.hashCode(this.versions);
        return hash;
    }

    public int compareTo(Object o) {
        Version v = (Version)o;
        int max = this.versionsLength() > v.versionsLength() ? this.versionsLength() : v.versionsLength();
        for (int i = 0; i < max; ++i) {
            int compare;
            int anotherVal;
            int thisVal = this.getVersion(i);
            int n = thisVal < (anotherVal = v.getVersion(i)) ? -1 : (compare = thisVal == anotherVal ? 0 : 1);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private int versionsLength() {
        return this.versions != null ? this.versions.length : 0;
    }

    public String toString() {
        if (this.versions != null) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < this.versions.length; ++i) {
                if (i > 0) {
                    buff.append('.');
                }
                if (this.versionsDisplay != null && this.versionsDisplay.length > i && this.versionsDisplay[i] != null) {
                    buff.append(this.versionsDisplay[i]);
                    continue;
                }
                buff.append(this.versions[i]);
            }
            if (this.variants != null) {
                buff.append(Arrays.stream(this.variants).map("-"::concat).collect(Collectors.joining()));
            }
            return buff.toString();
        }
        return "null";
    }
}

