/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.NumberUtil;
import com.cadwin.basic.misc.ValuesConstants;
import com.cadwin.basic.number.StrBigDecimal;
import com.cadwin.basic.number.UnitBaseInfos;

public class LinearBigDecimal
extends StrBigDecimal {
    private NumberUtil.LinearUnit linearUnit;

    public LinearBigDecimal(Object o) {
        this(o, null);
    }

    public LinearBigDecimal(Object o, NumberUtil.LinearUnit linearUnit) {
        super(o);
        this.linearUnit = linearUnit;
    }

    public NumberUtil.LinearUnit getUnit() {
        return this.linearUnit == null ? UnitBaseInfos.getLinearUnit() : this.linearUnit;
    }

    @Override
    public String toStringWithoutUnitDescription() {
        String result;
        if (ValuesConstants.isNull(this.doubleValue())) {
            result = "";
        } else {
            double value = this.doubleValueInUserDefinedUnit();
            result = UnitBaseInfos.getLinearFormatter(this.getUnit()).format(value);
        }
        return result;
    }

    @Override
    public String toString() {
        String resultWithoutUnitDesc = this.toStringWithoutUnitDescription();
        return resultWithoutUnitDesc.isEmpty() ? resultWithoutUnitDesc : resultWithoutUnitDesc + " " + this.getUnit().getDescription();
    }

    @Override
    public double doubleValueInUserDefinedUnit() {
        if (this.doubleValue() == Double.MIN_VALUE) {
            return this.doubleValue();
        }
        return this.doubleValue() * UnitBaseInfos.getInternalUnit() / this.getUnit().getConvertFactor();
    }
}

