/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.NumberUtil;
import com.cadwin.basic.misc.ValuesConstants;
import com.cadwin.basic.number.StrBigDecimal;
import com.cadwin.basic.number.UnitBaseInfos;

public class RatioBigDecimal
extends StrBigDecimal {
    private static final long serialVersionUID = 1L;
    private NumberUtil.RatioUnit ratioUnit;

    public RatioBigDecimal(Object o) {
        this(o, null);
    }

    public RatioBigDecimal(Object o, NumberUtil.RatioUnit ratioUnit) {
        super(o);
        this.ratioUnit = ratioUnit;
    }

    public NumberUtil.RatioUnit getUnit() {
        return this.ratioUnit == null ? UnitBaseInfos.getRatioUnit() : this.ratioUnit;
    }

    @Override
    public String toStringWithoutUnitDescription() {
        String result;
        if (ValuesConstants.isNull(this.doubleValue())) {
            result = "";
        } else {
            double value = this.doubleValueInUserDefinedUnit();
            result = UnitBaseInfos.getRatioFormatter(this.getUnit()).format(value);
        }
        return result;
    }

    @Override
    public String toString() {
        String resultWithoutUnitDesc = this.toStringWithoutUnitDescription();
        return resultWithoutUnitDesc.isEmpty() ? resultWithoutUnitDesc : resultWithoutUnitDesc + " " + this.getUnit().getDescription();
    }

    @Override
    public double doubleValueInUserDefinedUnit() {
        return this.doubleValue() / this.getUnit().getConvertFactor();
    }
}

