/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.NumberUtil;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;

public class UnitBaseInfos {
    private static Locale locale = Locale.getDefault();
    private static double internalUnit = 1.0;
    private static int maximumFractionDigits = 2;
    private static int currencyMaximumFractionDigits = 2;
    private static final Map<NumberUtil.LinearUnit, Integer> LINEAR_MAXIMUM_FRACTION_DIGITS_MAP = new EnumMap<NumberUtil.LinearUnit, Integer>(NumberUtil.LinearUnit.class);
    private static final Map<NumberUtil.SurfaceUnit, Integer> SURFACE_MAXIMUM_FRACTION_DIGITS_MAP = new EnumMap<NumberUtil.SurfaceUnit, Integer>(NumberUtil.SurfaceUnit.class);
    private static final Map<NumberUtil.VolumeUnit, Integer> VOLUME_MAXIMUM_FRACTION_DIGITS_MAP = new EnumMap<NumberUtil.VolumeUnit, Integer>(NumberUtil.VolumeUnit.class);
    private static final Map<NumberUtil.AngularUnit, Integer> ANGULAR_MAXIMUM_FRACTION_DIGITS_MAP = new EnumMap<NumberUtil.AngularUnit, Integer>(NumberUtil.AngularUnit.class);
    private static final Map<NumberUtil.RatioUnit, Integer> RATIO_MAXIMUM_FRACTION_DIGITS_MAP = new EnumMap<NumberUtil.RatioUnit, Integer>(NumberUtil.RatioUnit.class);
    private static NumberUtil.LinearUnit linearUnit = NumberUtil.LinearUnit.MM;
    private static NumberUtil.SurfaceUnit surfaceUnit = NumberUtil.SurfaceUnit.MM2;
    private static NumberUtil.VolumeUnit volumeUnit = NumberUtil.VolumeUnit.MM3;
    private static NumberUtil.AngularUnit angularUnit = NumberUtil.AngularUnit.DEGREE;
    private static NumberUtil.RatioUnit ratioUnit = NumberUtil.RatioUnit.PERCENT;
    private static NumberFormat numberFormatter;
    private static NumberFormat ratioFormatter;
    private static NumberFormat linearFormatter;
    private static NumberFormat surfaceFormatter;
    private static NumberFormat volumeFormatter;
    private static NumberFormat angluarFormatter;
    private static NumberFormat currencyFormatter;

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale l) {
        locale = l;
        Locale.setDefault(l);
        numberFormatter = null;
        ratioFormatter = null;
        linearFormatter = null;
        surfaceFormatter = null;
        volumeFormatter = null;
        angluarFormatter = null;
        currencyFormatter = null;
    }

    public static void setLinearMaximumFractionDigits(NumberUtil.LinearUnit unit, int newValue) {
        LINEAR_MAXIMUM_FRACTION_DIGITS_MAP.put(unit, newValue);
    }

    public static void setSurfaceMaximumFractionDigits(NumberUtil.SurfaceUnit unit, int newValue) {
        SURFACE_MAXIMUM_FRACTION_DIGITS_MAP.put(unit, newValue);
    }

    public static void setVolumeMaximumFractionDigits(NumberUtil.VolumeUnit unit, int newValue) {
        VOLUME_MAXIMUM_FRACTION_DIGITS_MAP.put(unit, newValue);
    }

    public static void setAngularMaximumFractionDigits(NumberUtil.AngularUnit unit, int newValue) {
        ANGULAR_MAXIMUM_FRACTION_DIGITS_MAP.put(unit, newValue);
    }

    public static void setRatioMaximumFractionDigits(NumberUtil.RatioUnit unit, int newValue) {
        RATIO_MAXIMUM_FRACTION_DIGITS_MAP.put(unit, newValue);
    }

    public static void setLinearUnit(NumberUtil.LinearUnit newValue) {
        linearUnit = newValue;
    }

    public static void setSurfaceUnit(NumberUtil.SurfaceUnit newValue) {
        surfaceUnit = newValue;
    }

    public static void setVolumeUnit(NumberUtil.VolumeUnit newValue) {
        volumeUnit = newValue;
    }

    public static void setAngularUnit(NumberUtil.AngularUnit newValue) {
        angularUnit = newValue;
    }

    public static void setRatioUnit(NumberUtil.RatioUnit newValue) {
        ratioUnit = newValue;
    }

    public static void setMaximumFractionDigits(int newValue) {
        maximumFractionDigits = newValue;
    }

    public static void setCurrencyMaximumFractionDigits(int newValue) {
        currencyMaximumFractionDigits = newValue;
    }

    public static void setInternalUnit(double newValue) {
        internalUnit = newValue;
    }

    public static void resetAll() {
        locale = Locale.getDefault();
        internalUnit = 1.0;
        maximumFractionDigits = 2;
        LINEAR_MAXIMUM_FRACTION_DIGITS_MAP.clear();
        SURFACE_MAXIMUM_FRACTION_DIGITS_MAP.clear();
        VOLUME_MAXIMUM_FRACTION_DIGITS_MAP.clear();
        ANGULAR_MAXIMUM_FRACTION_DIGITS_MAP.clear();
        RATIO_MAXIMUM_FRACTION_DIGITS_MAP.clear();
        linearUnit = NumberUtil.LinearUnit.MM;
        surfaceUnit = NumberUtil.SurfaceUnit.MM2;
        volumeUnit = NumberUtil.VolumeUnit.MM3;
        angularUnit = NumberUtil.AngularUnit.DEGREE;
        ratioUnit = NumberUtil.RatioUnit.PERCENT;
    }

    public static double getInternalUnit() {
        return internalUnit;
    }

    public static int getMaximumFractionDigits() {
        return maximumFractionDigits;
    }

    public static int getCurrencyMaximumFractionDigits() {
        return currencyMaximumFractionDigits;
    }

    public static int getLinearMaximumFractionDigits(NumberUtil.LinearUnit unit) {
        if (LINEAR_MAXIMUM_FRACTION_DIGITS_MAP.containsKey(unit)) {
            return LINEAR_MAXIMUM_FRACTION_DIGITS_MAP.get(unit);
        }
        return maximumFractionDigits;
    }

    public static int getSurfaceMaximumFractionDigits(NumberUtil.SurfaceUnit unit) {
        if (SURFACE_MAXIMUM_FRACTION_DIGITS_MAP.containsKey(unit)) {
            return SURFACE_MAXIMUM_FRACTION_DIGITS_MAP.get(unit);
        }
        return maximumFractionDigits;
    }

    public static int getVolumeMaximumFractionDigits(NumberUtil.VolumeUnit unit) {
        if (VOLUME_MAXIMUM_FRACTION_DIGITS_MAP.containsKey(unit)) {
            return VOLUME_MAXIMUM_FRACTION_DIGITS_MAP.get(unit);
        }
        return maximumFractionDigits;
    }

    public static int getAngularMaximumFractionDigits(NumberUtil.AngularUnit unit) {
        if (ANGULAR_MAXIMUM_FRACTION_DIGITS_MAP.containsKey(unit)) {
            return ANGULAR_MAXIMUM_FRACTION_DIGITS_MAP.get(unit);
        }
        return maximumFractionDigits;
    }

    public static int getRatioMaximumFractionDigits(NumberUtil.RatioUnit unit) {
        if (RATIO_MAXIMUM_FRACTION_DIGITS_MAP.containsKey(unit)) {
            return RATIO_MAXIMUM_FRACTION_DIGITS_MAP.get(unit);
        }
        if (unit == NumberUtil.RatioUnit.PERCENT) {
            return 1;
        }
        return maximumFractionDigits;
    }

    public static NumberUtil.LinearUnit getLinearUnit() {
        return linearUnit;
    }

    public static NumberUtil.SurfaceUnit getSurfaceUnit() {
        return surfaceUnit;
    }

    public static NumberUtil.VolumeUnit getVolumeUnit() {
        return volumeUnit;
    }

    public static NumberUtil.AngularUnit getAngularUnit() {
        return angularUnit;
    }

    public static NumberUtil.RatioUnit getRatioUnit() {
        return ratioUnit;
    }

    public static NumberFormat getNumberFormatter() {
        if (numberFormatter == null) {
            numberFormatter = NumberFormat.getInstance(Locale.getDefault());
        }
        numberFormatter.setMaximumFractionDigits(UnitBaseInfos.getMaximumFractionDigits());
        numberFormatter.setMinimumFractionDigits(UnitBaseInfos.getMaximumFractionDigits());
        return numberFormatter;
    }

    public static NumberFormat getPercentageFormatter() {
        return UnitBaseInfos.getRatioFormatter(NumberUtil.RatioUnit.PERCENT);
    }

    public static NumberFormat getRatioFormatter(NumberUtil.RatioUnit unit) {
        if (ratioFormatter == null) {
            ratioFormatter = NumberFormat.getInstance(UnitBaseInfos.getLocale());
        }
        ratioFormatter.setMaximumFractionDigits(UnitBaseInfos.getRatioMaximumFractionDigits(unit));
        ratioFormatter.setMinimumFractionDigits(UnitBaseInfos.getRatioMaximumFractionDigits(unit));
        return ratioFormatter;
    }

    public static NumberFormat getLinearFormatter(NumberUtil.LinearUnit unit) {
        if (linearFormatter == null) {
            linearFormatter = NumberFormat.getInstance(UnitBaseInfos.getLocale());
        }
        linearFormatter.setMaximumFractionDigits(UnitBaseInfos.getLinearMaximumFractionDigits(unit));
        linearFormatter.setMinimumFractionDigits(UnitBaseInfos.getLinearMaximumFractionDigits(unit));
        return linearFormatter;
    }

    public static NumberFormat getSurfaceFormatter(NumberUtil.SurfaceUnit unit) {
        if (surfaceFormatter == null) {
            surfaceFormatter = NumberFormat.getInstance(UnitBaseInfos.getLocale());
        }
        surfaceFormatter.setMaximumFractionDigits(UnitBaseInfos.getSurfaceMaximumFractionDigits(unit));
        surfaceFormatter.setMinimumFractionDigits(UnitBaseInfos.getSurfaceMaximumFractionDigits(unit));
        return surfaceFormatter;
    }

    public static NumberFormat getVolumeFormatter(NumberUtil.VolumeUnit unit) {
        if (volumeFormatter == null) {
            volumeFormatter = NumberFormat.getInstance(UnitBaseInfos.getLocale());
        }
        volumeFormatter.setMaximumFractionDigits(UnitBaseInfos.getVolumeMaximumFractionDigits(unit));
        volumeFormatter.setMinimumFractionDigits(UnitBaseInfos.getVolumeMaximumFractionDigits(unit));
        return volumeFormatter;
    }

    public static NumberFormat getAngluarFormatter(NumberUtil.AngularUnit unit) {
        if (angluarFormatter == null) {
            angluarFormatter = NumberFormat.getInstance(UnitBaseInfos.getLocale());
        }
        angluarFormatter.setMaximumFractionDigits(UnitBaseInfos.getAngularMaximumFractionDigits(unit));
        angluarFormatter.setMinimumFractionDigits(UnitBaseInfos.getAngularMaximumFractionDigits(unit));
        return angluarFormatter;
    }

    public static NumberFormat getCurrencyFormatter() {
        if (currencyFormatter == null) {
            currencyFormatter = NumberFormat.getInstance(UnitBaseInfos.getLocale());
        }
        currencyFormatter.setMaximumFractionDigits(UnitBaseInfos.getCurrencyMaximumFractionDigits());
        currencyFormatter.setMinimumFractionDigits(UnitBaseInfos.getCurrencyMaximumFractionDigits());
        return currencyFormatter;
    }

    private UnitBaseInfos() {
    }
}

