/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.NumberUtil;
import com.cadwin.basic.misc.ValuesConstants;
import com.cadwin.basic.number.StrBigDecimal;
import com.cadwin.basic.number.UnitBaseInfos;

public class VolumeBigDecimal
extends StrBigDecimal {
    private NumberUtil.VolumeUnit volumeUnit;

    public VolumeBigDecimal(Object o) {
        this(o, null);
    }

    public VolumeBigDecimal(Object o, NumberUtil.VolumeUnit volumeUnit) {
        super(o);
        this.volumeUnit = volumeUnit;
    }

    public NumberUtil.VolumeUnit getUnit() {
        return this.volumeUnit == null ? UnitBaseInfos.getVolumeUnit() : this.volumeUnit;
    }

    @Override
    public String toStringWithoutUnitDescription() {
        String result;
        if (ValuesConstants.isNull(this.doubleValue())) {
            result = "";
        } else {
            double value = this.doubleValueInUserDefinedUnit();
            result = UnitBaseInfos.getVolumeFormatter(this.getUnit()).format(value);
        }
        return result;
    }

    @Override
    public String toString() {
        String resultWithoutUnitDesc = this.toStringWithoutUnitDescription();
        return resultWithoutUnitDesc.isEmpty() ? resultWithoutUnitDesc : resultWithoutUnitDesc + " " + this.getUnit().getDescription();
    }

    @Override
    public double doubleValueInUserDefinedUnit() {
        return this.doubleValue() * UnitBaseInfos.getInternalUnit() * UnitBaseInfos.getInternalUnit() * UnitBaseInfos.getInternalUnit() / this.getUnit().getConvertFactor();
    }
}

