/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.picture;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PictureUtil {
    public static BufferedImage trimImage(BufferedImage image) {
        int y;
        int x;
        int top;
        WritableRaster raster = image.getAlphaRaster();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int left = 0;
        int right = width - 1;
        int bottom = height - 1;
        int minRight = width - 1;
        int minBottom = height - 1;
        block0: for (top = 0; top < bottom; ++top) {
            for (x = 0; x < width; ++x) {
                if (raster.getSample(x, top, 0) == 0) continue;
                minRight = x;
                minBottom = top;
                break block0;
            }
        }
        block2: while (left < minRight) {
            for (y = height - 1; y > top; --y) {
                if (raster.getSample(left, y, 0) == 0) continue;
                minBottom = y;
                break block2;
            }
            ++left;
        }
        block4: while (bottom > minBottom) {
            for (x = width - 1; x >= left; --x) {
                if (raster.getSample(x, bottom, 0) == 0) continue;
                minRight = x;
                break block4;
            }
            --bottom;
        }
        block6: while (right > minRight) {
            for (y = bottom; y >= top; --y) {
                if (raster.getSample(right, y, 0) != 0) break block6;
            }
            --right;
        }
        return image.getSubimage(left, top, right - left + 1, bottom - top + 1);
    }

    public static BufferedImage getBufferedImage(byte[] byteArray) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);){
            BufferedImage bufferedImage = ImageIO.read(bais);
            return bufferedImage;
        }
    }

    public static double getRescalingCoef(int srcWidth, int srcHeight, int tgtWidth, int tgtHeight) {
        double scaleX = Double.valueOf(tgtWidth) / Double.valueOf(srcWidth);
        double scaleY = Double.valueOf(tgtHeight) / Double.valueOf(srcHeight);
        return Math.min(scaleX, scaleY);
    }

    private PictureUtil() {
    }
}

