/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.Manifest;

public class ResourceUtil {
    public static String findSqlDriverClassName(ClassLoader cl) throws IOException {
        String className;
        try (InputStream is = cl.getResourceAsStream("META-INF/services/java.sql.Driver");
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            className = br.readLine();
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage());
        }
        return className;
    }

    public static Manifest findManifest(String title, ClassLoader cl) throws IOException {
        Enumeration<URL> resources = cl.getResources("META-INF/MANIFEST.MF");
        Manifest manifest = null;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream is = url.openStream();
            try {
                manifest = new Manifest(is);
                String implementationTitle = manifest.getMainAttributes().getValue("Implementation-Title");
                if (!Objects.nonNull(implementationTitle) || !implementationTitle.equalsIgnoreCase(title)) continue;
                break;
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return manifest;
    }

    public static String getValue(Manifest manifest, String valueName) {
        return manifest.getMainAttributes().getValue(valueName);
    }

    public static String getImplementationVersion(Manifest manifest) {
        return ResourceUtil.getValue(manifest, "Implementation-Version");
    }

    private ResourceUtil() {
    }
}

