/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.xml;

import com.cadwin.basic.dictionnary.StringsToEvaluateIF;
import com.cadwin.basic.misc.LocaleUtil;
import com.cadwin.basic.misc.NumberUtil;
import com.cadwin.basic.misc.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomUtil {
    private static final String TAG_OLD_LANG = "xml.lang";
    private static final Pattern PATTERN_FOR_NOT_BLANK = Pattern.compile("\n *");
    public static final String TAG_LANG = "xml:lang";
    private static final int NODE_VALUE_CAPACITY = 100;

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return factory;
    }

    public static TransformerFactory getTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return factory;
    }

    public static boolean hasNodeAttribute(Node node, String att) {
        if (node instanceof Element) {
            Element element = (Element)node;
            return element.hasAttribute(att);
        }
        return false;
    }

    public static String getNodeAttribute(Node node, String att, String defaultValue) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String attribute = element.getAttribute(att);
            return attribute == null || attribute.length() == 0 ? defaultValue : attribute;
        }
        return defaultValue;
    }

    public static String getNodeAttribute(Node node, String att) {
        return DomUtil.getNodeAttribute(node, att, null);
    }

    public static String getNodeTrimValue(Node node) {
        StringBuilder ret = new StringBuilder(100);
        DomUtil.appendNodeValue(ret, node);
        return ret.toString().trim();
    }

    public static String getNodeValue(Node node) {
        StringBuilder ret = new StringBuilder(100);
        DomUtil.appendNodeValue(ret, node);
        return ret.toString();
    }

    public static String getSubNodeValue(Node node, Locale locale, StringsToEvaluateIF tv, String tag) {
        LocaleString[] lss = DomUtil.getLocaleValues(node, tag);
        String defaultValue = null;
        for (LocaleString ls : lss) {
            if (ls.getLocale() == null) {
                if (tv != null) {
                    defaultValue = tv.evaluate(ls.getValue());
                    continue;
                }
                defaultValue = ls.getValue();
                continue;
            }
            if (ls.getLocale().equals(Locale.ENGLISH)) {
                defaultValue = ls.getValue();
            }
            if (!LocaleUtil.isCompatible(locale, ls.getLocale())) continue;
            return ls.getValue();
        }
        return defaultValue;
    }

    public static String getSubNodeValue(Node node, String tag) {
        return DomUtil.getSubNodeValue(node, null, null, tag);
    }

    public static String[] getSubNodeTrimValues(Node node, String tag) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        String[] values = new String[list.getLength()];
        for (int s = 0; s < list.getLength(); ++s) {
            values[s] = DomUtil.getNodeTrimValue(list.item(s));
        }
        return values;
    }

    public static String[] getSubNodeValues(Node node, String tag) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        String[] values = new String[list.getLength()];
        for (int s = 0; s < list.getLength(); ++s) {
            values[s] = DomUtil.getNodeValue(list.item(s));
        }
        return values;
    }

    public static int[] getSubNodeIntValues(Node node, String tag) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        int[] values = new int[list.getLength()];
        for (int s = 0; s < list.getLength(); ++s) {
            values[s] = NumberUtil.intValue(DomUtil.getNodeTrimValue(list.item(s)));
        }
        return values;
    }

    public static long[] getSubNodeLongValues(Node node, String tag) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        long[] values = new long[list.getLength()];
        for (int s = 0; s < list.getLength(); ++s) {
            values[s] = NumberUtil.longValue(DomUtil.getNodeTrimValue(list.item(s)));
        }
        return values;
    }

    public static boolean[] getSubNodeBooleanValues(Node node, String tag) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        boolean[] values = new boolean[list.getLength()];
        for (int s = 0; s < list.getLength(); ++s) {
            values[s] = StringUtil.getBoolean(DomUtil.getNodeTrimValue(list.item(s)));
        }
        return values;
    }

    public static String[] getSubNodeAttributeValues(Node node, String tag, String att) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        String[] values = new String[list.getLength()];
        for (int s = 0; s < list.getLength(); ++s) {
            values[s] = DomUtil.getNodeAttribute(list.item(s), att);
        }
        return values;
    }

    public static Node findChildNode(Node node, String tag) {
        return DomUtil.findChildNode(node, tag, false);
    }

    public static Node findChildNode(Node node, String tag, boolean ignoreCase) {
        NodeList list = DomUtil.getElementsByTagName(node, tag, ignoreCase);
        if (list.getLength() > 0) {
            return list.item(0);
        }
        return null;
    }

    public static Locale getLocale(Node node) {
        String lang = DomUtil.getLang(node);
        if (lang == null || lang.length() == 0) {
            return null;
        }
        return LocaleUtil.toLocale(lang);
    }

    public static String getLang(Node node) {
        String lang = DomUtil.getNodeAttribute(node, TAG_LANG);
        if (lang == null || lang.length() == 0) {
            lang = DomUtil.getNodeAttribute(node, TAG_OLD_LANG);
        }
        return lang;
    }

    public static LocaleString[] getLocaleValues(Node node, String tag) {
        NodeList list = DomUtil.getElementsByTagName(node, tag);
        LocaleString[] lss = new LocaleString[list.getLength()];
        for (int i = 0; i < lss.length; ++i) {
            String value = DomUtil.getNodeTrimValue(list.item(i));
            Locale locale = DomUtil.getLocale(list.item(i));
            lss[i] = new LocaleString(locale, value);
        }
        return lss;
    }

    public static NodeList getElementsByTagName(Node node, String tag) {
        return DomUtil.getElementsByTagName(node, tag, false);
    }

    public static NodeList getElementsByTagName(Node node, String tag, boolean ignoreCase) {
        MyNodeList list = new MyNodeList();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(ignoreCase ? tag.equalsIgnoreCase(child.getNodeName()) : tag.equals(child.getNodeName()))) continue;
            list.add(child);
        }
        return list;
    }

    public static NodeList getElementsByTagNames(Node node, List<String> tagNames) {
        return DomUtil.getElementsByTagNames(node, tagNames, false);
    }

    public static NodeList getElementsByTagNames(Node node, List<String> tagNames, boolean ignoreCase) {
        MyNodeList list = new MyNodeList();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(ignoreCase ? tagNames.stream().anyMatch(tag -> tag.equalsIgnoreCase(child.getNodeName())) : tagNames.stream().anyMatch(tag -> tag.equals(child.getNodeName())))) continue;
            list.add(child);
        }
        return list;
    }

    public static void removeWhiteSpaces(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                Text nodeText = (Text)child;
                nodeText.setData(nodeText.getData().trim());
            }
            DomUtil.removeWhiteSpaces(child);
        }
    }

    public static int getDepth(Node elem) {
        return DomUtil.getDepth(elem, -1);
    }

    private static int getDepth(Node elem, int cpt) {
        Node parent = elem.getParentNode();
        if (parent != null) {
            return DomUtil.getDepth(parent, cpt + 1);
        }
        return cpt;
    }

    public static String normalizeStringValueFragment(String fragment) {
        String result = fragment == null ? null : (!fragment.isEmpty() && fragment.charAt(0) == '\n' ? DomUtil.notBlank(fragment.substring(1)) : DomUtil.notBlank(fragment));
        return result;
    }

    private static String notBlank(String str) {
        return str.isBlank() ? "" : PATTERN_FOR_NOT_BLANK.matcher(str).replaceAll(" ");
    }

    private static void appendNodeValue(StringBuilder ret, Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() == 5) {
                DomUtil.appendNodeValue(ret, list.item(i));
                continue;
            }
            String value = list.item(i).getNodeValue();
            if (value == null) continue;
            ret.append(DomUtil.normalizeStringValueFragment(value));
        }
    }

    public static String writeXML(Node node) throws TransformerException {
        String string;
        TransformerFactory fabriqueT = DomUtil.getTransformerFactory();
        Transformer transformer = fabriqueT.newTransformer();
        StringWriter sw = new StringWriter();
        try {
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            string = ((Object)sw).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)sw).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TransformerException("Failed to write the XML content of a node into a String", ioe);
            }
        }
        ((Writer)sw).close();
        return string;
    }

    public static void writeXmlFile(Document doc, File file) throws Exception {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            Transformer xformer = DomUtil.getTransformerFactory().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("standalone", "no");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            Files.delete(file.toPath());
            throw e;
        }
    }

    private DomUtil() {
    }

    private static class MyNodeList<T>
    extends ArrayList<T>
    implements NodeList {
        private MyNodeList() {
        }

        @Override
        public Node item(int index) {
            return (Node)this.get(index);
        }

        @Override
        public int getLength() {
            return this.size();
        }
    }

    public static class LocaleString {
        private Locale locale;
        private String value;

        public LocaleString(String value) {
            this(null, value);
        }

        public LocaleString(Locale locale, String value) {
            this.locale = locale;
            this.value = value;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
            this.value = v;
        }
    }
}

