/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.xml;

import com.cadwin.basic.misc.LocaleUtil;
import com.cadwin.basic.misc.StringUtil;
import com.cadwin.basic.xml.SAXString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StrXmlHandler
extends DefaultHandler {
    private static final String TAG_HEADER = "header";
    private static final String TAG_ROW = "row";
    private static final String TAG_COLUMN = "column";
    private static final String ATT_SELECTOR = "selector";
    private static final String ATT_LANG = "xml:lang";
    private boolean startRowdata;
    private boolean startHeader;
    private int currentColumnIndex;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Locale> locales = new ArrayList<Locale>();
    private final SAXString columnValue = new SAXString();
    private final Map<String, String> currentRow = new HashMap<String, String>();
    private final RowActionIF rowAction;

    public StrXmlHandler(RowActionIF rowAction) {
        this.rowAction = rowAction;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.columnValue.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.startRowdata) {
            if (TAG_COLUMN.equals(qName)) {
                ++this.currentColumnIndex;
                this.columnValue.reset();
            }
        } else if (this.startHeader) {
            if (TAG_COLUMN.equals(qName)) {
                ++this.currentColumnIndex;
                this.columnNames.add(attributes.getValue(ATT_SELECTOR));
                String lang = attributes.getValue(ATT_LANG);
                if (lang != null) {
                    Locale locale = LocaleUtil.toLocale(lang);
                    this.locales.add(locale);
                } else {
                    this.locales.add(null);
                }
                this.columnValue.reset();
            }
        } else if (TAG_ROW.equals(qName)) {
            this.startRowdata = true;
            this.currentColumnIndex = -1;
        } else if (TAG_HEADER.equals(qName)) {
            this.startHeader = true;
            this.currentColumnIndex = -1;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.startRowdata) {
            if (TAG_COLUMN.equals(qName)) {
                String grossValue = this.columnValue.toString().trim();
                String value = StringUtil.isNullOrEmpty(grossValue) ? null : grossValue;
                Locale locale = this.locales.get(this.currentColumnIndex);
                String columnName = this.columnNames.get(this.currentColumnIndex);
                if (locale == null) {
                    this.currentRow.put(columnName, value);
                } else {
                    if (LocaleUtil.isCompatible(Locale.ENGLISH, locale) && this.currentRow.get(columnName) == null) {
                        this.currentRow.put(columnName, value);
                    }
                    if (LocaleUtil.isCompatible(Locale.getDefault(), locale) && (value != null || !this.currentRow.containsKey(columnName))) {
                        this.currentRow.put(columnName, value);
                    }
                }
            } else if (TAG_ROW.endsWith(qName)) {
                this.rowAction.rowRead(this.currentRow);
                this.currentRow.clear();
                this.startRowdata = false;
            }
        } else if (this.startHeader) {
            if (TAG_COLUMN.equals(qName)) {
                if (this.columnNames.get(this.currentColumnIndex) == null) {
                    this.columnNames.set(this.currentColumnIndex, this.columnValue.toString().trim());
                }
            } else if (TAG_HEADER.endsWith(qName)) {
                this.startHeader = false;
            }
        }
    }

    public static interface RowActionIF {
        public void rowRead(Map<String, String> var1);
    }
}

