/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.zip;

import com.cadwin.basic.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final Logger LOGGER = Logger.getLogger(ZipUtil.class);

    public static ByteArrayOutputStream compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            LOGGER.debug(e);
        }
        return bos;
    }

    public static void unzip(File archiveFile, File destDirectory, Charset encoding) throws IOException {
        try (ZipFile zipFile = new ZipFile(archiveFile, encoding);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream in = zipFile.getInputStream(entry);
                try {
                    if (in == null || entry.isDirectory()) continue;
                    File outFile = new File(destDirectory, entry.getName());
                    outFile.getParentFile().mkdirs();
                    Files.copy(in, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    public static void zip(Path archive, final Path sourceDirectory, final Predicate<Path> select, int compressionLevel, Charset encoding, final boolean embedEmptyFolders) throws IOException {
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(archive, new OpenOption[0]), encoding);){
            zos.setLevel(compressionLevel);
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                private String getRelativePath(Path p) {
                    return sourceDirectory.relativize(p).toString().replace("\\", "/");
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (select.test(file)) {
                        zos.putNextEntry(new ZipEntry(this.getRelativePath(file)));
                        Files.copy(file, zos);
                        zos.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!dir.equals(sourceDirectory) && select.test(dir) && (embedEmptyFolders || dir.toFile().listFiles(File::isFile).length > 0)) {
                        zos.putNextEntry(new ZipEntry(this.getRelativePath(dir) + "/"));
                        zos.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void zip(Path archive, Path sourceDirectory, int compressionLevel) throws IOException {
        ZipUtil.zip(archive, sourceDirectory, p -> true, compressionLevel, Charset.defaultCharset(), false);
    }

    private ZipUtil() {
    }
}

