/*
 * Decompiled with CFR 0.152.
 */
package db.manager.datasource;

import db.manager.constant.database.DatabaseInstance;
import db.manager.constant.database.XmDbDef;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSourceUtil {
    private static final String JDBC_THIN_PREFIX = "jdbc:oracle:thin:@";
    private static final String JDBC_SID_PATTERN = "%s%s:%s:%s";
    private static final String JDBC_SERVICE_PATTERN = "%s//%s:%s/%s";

    public static String getServiceConnectionString(DatabaseInstance databaseInstance) {
        String host = databaseInstance.getHost();
        String port = databaseInstance.getPort();
        String name = databaseInstance.getName();
        boolean service = databaseInstance.isService();
        return String.format("(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%s)))(CONNECT_DATA=(%s=%s)))", host, port, service ? "SERVICE_NAME" : "SID", name);
    }

    private static String buildJDBCURL(String pattern, String hostname, String port, String name) {
        return String.format(pattern, JDBC_THIN_PREFIX, hostname, port, name);
    }

    public static String buildJDBCURL(DatabaseInstance databaseInstance) {
        String host = databaseInstance.getHost();
        String port = databaseInstance.getPort();
        String name = databaseInstance.getName();
        return DataSourceUtil.buildJDBCURL(databaseInstance.isService() ? JDBC_SERVICE_PATTERN : JDBC_SID_PATTERN, host, port, name);
    }

    public static XmDbDef extractFromUrl(String url, String userName, String password, String adminName, String adminPassword) {
        Pattern patternForOracleJDBCThinURLSID = Pattern.compile("^jdbc:oracle:thin:.*@(.+):([0-9]*):(.+)");
        Pattern patternForOracleJDBCThinURLSERVICE = Pattern.compile("^jdbc:oracle:thin:.*@//(.+):([0-9]*)/(.+)");
        Matcher matcherSID = patternForOracleJDBCThinURLSID.matcher(url);
        Matcher matcherSERVICE = patternForOracleJDBCThinURLSERVICE.matcher(url);
        boolean matchSID = matcherSID.find();
        boolean matchSERVICE = matcherSERVICE.find();
        if (matchSID) {
            String serverName = matcherSID.group(1);
            String port = matcherSID.group(2);
            String serviceName = matcherSID.group(3);
            return new XmDbDef(serverName, port, serviceName, false, userName, password, adminName, adminPassword);
        }
        if (matchSERVICE) {
            String serverName = matcherSERVICE.group(1);
            String port = matcherSERVICE.group(2);
            String serviceName = matcherSERVICE.group(3);
            return new XmDbDef(serverName, port, serviceName, true, userName, password, adminName, adminPassword);
        }
        return null;
    }

    private DataSourceUtil() {
    }
}

