/*
 * Decompiled with CFR 0.152.
 */
package db.manager.exec.save;

import db.manager.datapump.DatapumpFileActionFactory;
import db.manager.datapump.DatapumpFileActionIF;
import db.manager.datasource.DataSourceFactory;
import db.manager.datasource.DbmsOutput;
import db.manager.exec.observer.ExecutionObserver;
import db.manager.exec.save.SaveActionDef;
import db.manager.exec.tools.SQLUtil;
import db.manager.files.FileUtil;
import db.manager.queries.SqlUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SaveService {
    private static final Logger LOGGER = Logger.getLogger(SaveService.class);
    private static final FileFilter ZIP_FILE_FILTER = f -> !f.getName().contains(".bak") || f.getName().contains("Thumbs.db");

    private static void icmd1Step(SaveActionDef saveActionDef) throws IOException {
        try (InputStream in = SaveService.class.getResourceAsStream("/db/manager/resource/i-cmd1-4-dbassistant-compatibility.sql");){
            Path dst = Paths.get(saveActionDef.getDatabaseFolderPath(), "import-export", "i-cmd1.sql");
            Files.copy(in, dst, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void save(SaveActionDef saveActionDef) {
        String action = "save";
        saveActionDef.getObserver().start("save");
        try {
            SaveService.infoStep(saveActionDef);
            SaveService.userScriptStep(saveActionDef);
            SaveService.exportNoCopyStep(saveActionDef);
            SaveService.copyPostExportStep(saveActionDef);
            SaveService.icmd1Step(saveActionDef);
            SaveService.zipStep(saveActionDef);
            saveActionDef.getObserver().end();
        }
        catch (IOException | SQLException e) {
            saveActionDef.setActionFailed();
            saveActionDef.getObserver().error("save error", e);
        }
    }

    public static void export(SaveActionDef saveActionDef) {
        try {
            SaveService.exportNoCopyStep(saveActionDef);
            SaveService.copyPostExportStep(saveActionDef);
        }
        catch (IOException | SQLException e) {
            saveActionDef.getObserver().error("export error", e);
        }
    }

    public static void zip(SaveActionDef saveActionDef) {
        try {
            SaveService.zipStep(saveActionDef);
        }
        catch (IOException ioe) {
            saveActionDef.getObserver().error("zip error", ioe);
        }
    }

    private static void infoStep(SaveActionDef saveActionDef) throws SQLException {
        String actionDefName = "info";
        saveActionDef.getObserver().start("info");
        DataSource systemDS = DataSourceFactory.getDataSourceSystem(saveActionDef.getDataSourceInfos());
        try (Connection connection = systemDS.getConnection();){
            String sessionsStmt = SqlUtil.getQuery("SESSIONS");
            try (PreparedStatement ps = connection.prepareStatement(sessionsStmt);
                 ResultSet rs = ps.executeQuery();){
                saveActionDef.getObserver().addContentWithLineBreak("active sessions");
                while (rs.next()) {
                    Long sessionId = SqlUtil.getLong(rs, "SID");
                    Long serialNumber = SqlUtil.getLong(rs, "SERIAL#");
                    String userName = rs.getString("USERNAME");
                    String machineName = rs.getString("MACHINE");
                    String osUserName = rs.getString("OSUSER");
                    String programName = rs.getString("PROGRAM");
                    String moduleName = rs.getString("MODULE");
                    String action = rs.getString("ACTION");
                    String clientInfo = rs.getString("CLIENT_INFO");
                    String logLine = String.format("sid(%6d) serial#(%6d) user(%-16s) machine(%-20s) os user(%-16s) program(%-16s) module(%-20s) action(%-40s) client info(%-30s)", sessionId, serialNumber, userName, machineName, osUserName, programName, moduleName, action, clientInfo);
                    saveActionDef.getObserver().addContentWithLineBreak(logLine);
                }
            }
        }
        saveActionDef.getObserver().end();
    }

    private static void userScriptStep(SaveActionDef saveActionDef) throws IOException, SQLException {
        String userSQLScriptFilePath = saveActionDef.getUserSQLScriptFilePath();
        if (userSQLScriptFilePath != null) {
            String action = "user script";
            saveActionDef.getObserver().start("user script");
            File scriptFile = new File(userSQLScriptFilePath);
            if (scriptFile.exists()) {
                DataSource schemaDatasource = DataSourceFactory.getDataSourceUser(saveActionDef.getDataSourceInfos());
                SQLUtil.executeScriptOnDatasource(saveActionDef.getObserver(), schemaDatasource, scriptFile);
            }
            saveActionDef.getObserver().end();
        }
    }

    private static void exportNoCopyStep(SaveActionDef saveActionDef) throws IOException, SQLException {
        String action = "export";
        saveActionDef.getObserver().start("export");
        File importExportDirectory = new File(saveActionDef.getDatabaseFolderPath(), "import-export");
        String deletingFolderMsg = String.format("deleting content of directory %s", importExportDirectory.getAbsolutePath());
        saveActionDef.getObserver().addContentWithLineBreak(deletingFolderMsg);
        saveActionDef.getObserver().addLineBreak();
        LOGGER.debug((Object)deletingFolderMsg);
        if (!importExportDirectory.exists()) {
            importExportDirectory.mkdir();
        }
        if (importExportDirectory.listFiles() != null) {
            List<File> files = Arrays.asList(importExportDirectory.listFiles());
            files.forEach(File::delete);
        }
        File infos = new File(importExportDirectory, "infos.txt");
        String creatingFileMsg = String.format("creating file %s", infos.getAbsolutePath());
        saveActionDef.getObserver().addContentWithLineBreak(creatingFileMsg);
        saveActionDef.getObserver().addLineBreak();
        LOGGER.debug((Object)creatingFileMsg);
        try (PrintWriter pw = new PrintWriter(infos, "UTF-8");){
            pw.println(String.format("schema=%s, role=%s", saveActionDef.getDataSourceInfos().getSchema(), saveActionDef.getUserRole()));
        }
        File databaseFolder = new File(saveActionDef.getDatabaseFolderPath());
        File scriptFile = new File(new File(databaseFolder, "batch"), "dbassistant4-expdp-tmpl.sql");
        DataSource systemDS = DataSourceFactory.getDataSourceSystem(saveActionDef.getDataSourceInfos());
        try (Connection c = systemDS.getConnection();
             DbmsOutput dbmsOutput = new DbmsOutput(c);
             FileInputStream is = new FileInputStream(scriptFile);){
            LOGGER.debug((Object)String.format("exporting schema %s", saveActionDef.getDataSourceInfos().getSchema()));
            String scriptToExecute = FileUtil.readFile(is);
            scriptToExecute = scriptToExecute.replace("@SCHEMA@", saveActionDef.getDataSourceInfos().getSchema()).replace("@HEADER@", "");
            scriptToExecute = scriptToExecute.substring(0, scriptToExecute.toLowerCase().lastIndexOf("end;") + 4);
            String runningScriptMsg = String.format("running %s", scriptFile.getCanonicalPath());
            saveActionDef.getObserver().addLineBreak();
            saveActionDef.getObserver().addContentWithLineBreak(runningScriptMsg);
            LOGGER.debug((Object)runningScriptMsg);
            dbmsOutput.enable(100000);
            try (CallableStatement cs = c.prepareCall(scriptToExecute);){
                cs.execute();
            }
            saveActionDef.getObserver().addLineBreak();
            saveActionDef.getObserver().addContentWithLineBreak(dbmsOutput.getLines());
        }
        saveActionDef.getObserver().end();
    }

    private static void copyPostExportStep(SaveActionDef saveActionDef) throws IOException, SQLException {
        String action = "copyPostExport";
        saveActionDef.getObserver().start("copyPostExport");
        File importExportDirectory = new File(saveActionDef.getDatabaseFolderPath(), "import-export");
        File dataPumpDirectory = new File(saveActionDef.getDpdumpFolderPath());
        String copyingMsg = String.format("copying .dmp and .log from %s to %s", saveActionDef.getDpdumpFolderPath(), importExportDirectory.getAbsolutePath());
        saveActionDef.getObserver().addContentWithLineBreak(copyingMsg);
        LOGGER.debug((Object)copyingMsg);
        File source = new File(dataPumpDirectory, saveActionDef.getDataSourceInfos().getSchema() + ".dmp");
        File target = new File(importExportDirectory, "datapump.dmp");
        DatapumpFileActionIF datapumpFileAction = DatapumpFileActionFactory.getDatapumpAction(saveActionDef.getDpdumpFolderPath(), saveActionDef.getDataSourceInfos().getSchema() + ".dmp");
        datapumpFileAction.getFromServer(target.toPath());
        File targetLog = new File(importExportDirectory, saveActionDef.getDataSourceInfos().getSchema() + ".dmp");
        DatapumpFileActionIF datapumpLogFileAction = DatapumpFileActionFactory.getDatapumpAction(saveActionDef.getDpdumpFolderPath(), saveActionDef.getDataSourceInfos().getSchema() + ".log");
        datapumpLogFileAction.getFromServer(targetLog.toPath());
        String deletingFileMsg = String.format("deleting file %s", source.getAbsolutePath());
        saveActionDef.getObserver().addContentWithLineBreak(deletingFileMsg);
        LOGGER.debug((Object)deletingFileMsg);
        datapumpFileAction.deleteFromServer();
        saveActionDef.getObserver().end();
    }

    private static void zipStep(SaveActionDef saveActionDef) throws IOException {
        String action = "zip";
        saveActionDef.getObserver().start("zip");
        File zip = new File(saveActionDef.getZipFilePath());
        if (zip.exists()) {
            zip.delete();
        }
        File databaseDir = new File(saveActionDef.getDatabaseFolderPath());
        saveActionDef.getObserver().addContentWithLineBreak(String.format("creating archive %s", zip.getAbsolutePath()));
        DynamicEntryFilter dynamicEntryFilter = new DynamicEntryFilter(saveActionDef.isDpdumpOnly(), saveActionDef.isWebAppsToBeSaved(), saveActionDef.isJreToBeSaved());
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));){
            zos.setLevel(1);
            SaveService.zipDirectoryContent(zos, databaseDir, databaseDir, dynamicEntryFilter, saveActionDef.getObserver());
        }
        LOGGER.debug((Object)String.format("%s : %s", "zip", zip.getAbsolutePath()));
        saveActionDef.getObserver().end();
    }

    private static String getFileBasename(File file, File origin) throws IOException {
        return file.getCanonicalPath().substring(origin.getCanonicalPath().length() + 1);
    }

    private static String buildEntryName(File file, File origin) throws IOException {
        return FileUtil.toUnixStyle(SaveService.getFileBasename(file, origin));
    }

    private static void putNextEntry(ZipOutputStream zos, String entryName, File f) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setLastModifiedTime(FileTime.fromMillis(f.lastModified()));
        zos.putNextEntry(entry);
    }

    private static void zipDirectoryContent(ZipOutputStream zos, File origin, File directory, DynamicEntryFilter dynamicEntryFilter, ExecutionObserver observer) throws IOException {
        byte[] buffer = new byte[4096];
        List<File> files = Arrays.asList(directory.listFiles(ZIP_FILE_FILTER));
        for (File f : files) {
            Object zipEntryName;
            if (f.isDirectory()) {
                zipEntryName = SaveService.buildEntryName(f, origin) + "/";
                if (!dynamicEntryFilter.retain((String)zipEntryName)) continue;
                observer.addContentWithLineBreak(String.format("compressing %s", zipEntryName));
                SaveService.putNextEntry(zos, (String)zipEntryName, f);
                zos.closeEntry();
                SaveService.zipDirectoryContent(zos, origin, f, dynamicEntryFilter, observer);
                continue;
            }
            zipEntryName = SaveService.buildEntryName(f, origin);
            observer.addContentWithLineBreak(String.format("compressing %s", zipEntryName));
            try (FileInputStream fis = new FileInputStream(f);){
                SaveService.putNextEntry(zos, (String)zipEntryName, f);
                int len = fis.read(buffer);
                while (len > 0) {
                    zos.write(buffer, 0, len);
                    len = fis.read(buffer);
                }
                zos.closeEntry();
            }
        }
    }

    private SaveService() {
    }

    private static class DynamicEntryFilter {
        private final boolean isDpdumpOnly;
        private final boolean isWebAppsToBeSaved;
        private final boolean isJreToBeSaved;

        DynamicEntryFilter(boolean isDpdumpOnly, boolean isWebAppsToBeSaved, boolean isJreToBeSaved) {
            this.isDpdumpOnly = isDpdumpOnly;
            this.isWebAppsToBeSaved = isWebAppsToBeSaved;
            this.isJreToBeSaved = isJreToBeSaved;
        }

        boolean retain(String zipEntryName) {
            if (this.isDpdumpOnly) {
                return zipEntryName.startsWith("import-export/") || zipEntryName.startsWith("users/");
            }
            return !(!this.isWebAppsToBeSaved && "lib.webapps/".equals(zipEntryName) || !this.isJreToBeSaved && "_scripts/jre/".equals(zipEntryName));
        }
    }
}

