/*
 * Decompiled with CFR 0.152.
 */
package db.manager.properties;

import db.manager.strings.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesUtil {
    private static final Logger LOGGER = Logger.getLogger(PropertiesUtil.class);

    public static Properties loadPropertiesFromResourceEx(String resourcePath, ClassLoader classLoader) throws IOException {
        Properties prop = new Properties();
        String tgtResourcePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        ClassLoader tgtClassLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        try (InputStream propInputStream = tgtClassLoader.getResourceAsStream(tgtResourcePath);){
            if (propInputStream != null) {
                prop.load(propInputStream);
            }
        }
        return prop;
    }

    public static Properties loadPropertiesFromResource(String resourcePath, ClassLoader classLoader) {
        Properties prop = new Properties();
        try {
            prop = PropertiesUtil.loadPropertiesFromResourceEx(resourcePath, classLoader);
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)String.format("Caught exception while loading resource at path (%s)", resourcePath));
        }
        return prop;
    }

    public static Properties loadPropertiesFromResourceEx(String resourcePath, Class<?> cls) throws IOException {
        Properties prop = new Properties();
        try (InputStream propInputStream = cls.getResourceAsStream(resourcePath);){
            if (propInputStream != null) {
                prop.load(propInputStream);
            }
        }
        return prop;
    }

    public static Properties loadPropertiesFromResource(String resourcePath, Class<?> cls) {
        Properties prop = new Properties();
        try {
            prop = PropertiesUtil.loadPropertiesFromResourceEx(resourcePath, cls);
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)String.format("Caught exception while loading at path (%s)", resourcePath));
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLResourceEx(String resourcePath, ClassLoader classLoader) throws IOException {
        Properties prop = new Properties();
        String tgtResourcePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        ClassLoader tgtClassLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        try (InputStream propInputStream = tgtClassLoader.getResourceAsStream(tgtResourcePath);){
            if (propInputStream != null) {
                prop.loadFromXML(propInputStream);
            }
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLResource(String resourcePath, ClassLoader classLoader) {
        Properties prop = new Properties();
        try {
            prop = PropertiesUtil.loadPropertiesFromXMLResourceEx(resourcePath, classLoader);
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)String.format("Caught exception while loading resource at path (%s)", resourcePath));
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLResourceEx(String resourcePath, Class<?> cls) throws IOException {
        Properties prop = new Properties();
        try (InputStream propInputStream = cls.getResourceAsStream(resourcePath);){
            if (propInputStream != null) {
                prop.loadFromXML(propInputStream);
            }
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLResource(String resourcePath, Class<?> cls) {
        Properties prop = new Properties();
        try {
            prop = PropertiesUtil.loadPropertiesFromXMLResourceEx(resourcePath, cls);
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)String.format("Caught exception while loading at path (%s)", resourcePath));
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLResourceEx(String resourcePath) throws IOException {
        return PropertiesUtil.loadPropertiesFromXMLResourceEx(resourcePath, Thread.currentThread().getContextClassLoader());
    }

    public static Properties loadPropertiesFromXMLResource(String resourcePath) {
        return PropertiesUtil.loadPropertiesFromXMLResource(resourcePath, Thread.currentThread().getContextClassLoader());
    }

    public static Properties loadPropertiesFromXMLFileEx(String filePath) throws IOException {
        Properties prop = new Properties();
        try (FileInputStream propInputStream = new FileInputStream(filePath);){
            if (propInputStream != null) {
                prop.loadFromXML(propInputStream);
            }
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLFile(String filePath) {
        Properties prop = new Properties();
        try {
            prop = PropertiesUtil.loadPropertiesFromXMLFileEx(filePath);
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)String.format("Caught exception while loading at path (%s)", filePath));
        }
        return prop;
    }

    public static Properties loadPropertiesFromXMLFileEx(File file) throws IOException {
        Properties prop = new Properties();
        try (FileInputStream propInputStream = new FileInputStream(file);){
            if (propInputStream != null) {
                prop.loadFromXML(propInputStream);
            }
        }
        return prop;
    }

    public static void savePropertiesOnXmlFileEx(Properties properties, String filePath) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            properties.storeToXML(outputStream, null);
        }
    }

    public static void savePropertiesOnXmlFile(Properties properties, String filePath) {
        try {
            PropertiesUtil.savePropertiesOnXmlFileEx(properties, filePath);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)String.format("Caught exception while writing at path (%s)", filePath), (Throwable)ioe);
        }
    }

    public static Integer safeParseInt(String txt) {
        Integer value = null;
        try {
            value = Integer.parseInt(txt);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn((Object)("Unable to parse integer : " + txt), (Throwable)nfe);
        }
        return value;
    }

    public static Long safeParseLong(String txt) {
        Long value = null;
        try {
            value = Long.parseLong(txt);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn((Object)("Unable to parse long : " + txt), (Throwable)nfe);
        }
        return value;
    }

    public static int getIntProperty(Properties prop, String key, int defaultValue) {
        String valueImg = prop.getProperty(key);
        if (StringUtil.isEmpty(valueImg)) {
            return defaultValue;
        }
        Integer value = PropertiesUtil.safeParseInt(valueImg);
        return value == null ? defaultValue : value;
    }

    public static long getLongProperty(Properties prop, String key, long defaultValue) {
        String valueImg = prop.getProperty(key);
        if (StringUtil.isEmpty(valueImg)) {
            return defaultValue;
        }
        Long value = PropertiesUtil.safeParseLong(valueImg);
        return value == null ? defaultValue : value;
    }

    public static boolean getBooleanProperty(Properties prop, String key, boolean defaultValue) {
        String valueImg = prop.getProperty(key);
        if (StringUtil.isEmpty(valueImg)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(valueImg);
    }

    public static String getStringProperty(Properties prop, String key, String defaultValue) {
        String valueImg = prop.getProperty(key);
        if (StringUtil.isEmpty(valueImg)) {
            return defaultValue;
        }
        return valueImg;
    }

    private PropertiesUtil() {
    }
}

