/*
 * Decompiled with CFR 0.152.
 */
package db.manager.strings;

public class StringUtil {
    private static String getFirstSlice(String value) {
        String[] slices = value.split("\\.");
        return slices[0];
    }

    public static String getPluggableDbGlobalName(String service) {
        return StringUtil.getFirstSlice(service);
    }

    public static String getHostName(String fqdn) {
        return StringUtil.getFirstSlice(fqdn);
    }

    public static String formatDuration(long durationMillis) {
        long second = durationMillis / 1000L % 60L;
        long minute = durationMillis / 60000L % 60L;
        long hour = durationMillis / 3600000L % 24L;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private StringUtil() {
    }
}

