/*
 * Decompiled with CFR 0.152.
 */
package db.manager.cmd;

import db.manager.cmd.CmdExecutionObserver;
import db.manager.cmd.CmdUtil;
import db.manager.constant.database.XmDbDef;
import db.manager.exec.restore.RestoreActionDef;
import db.manager.exec.restore.RestoreService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DBRestoreCmd {
    private static final Logger LOGGER = Logger.getLogger(DBRestoreCmd.class);
    private static final String ARGKEY_DELETEDBFOLDER = "-deletedbfolder";
    private static final String ARGKEY_SCHEMANAME = "-schemaname";
    private static final String ARGKEY_ORACLEHOSTNAME = "-oraclehostname";
    private static final String ARGKEY_ORACLEPORT = "-oracleport";
    private static final String ARGKEY_ORACLESID = "-oraclesid";
    private static final String ARGKEY_ORACLESERVICE = "-oracleservice";
    private static final String ARGKEY_DPDUMPONLY = "-dpdumponly";
    private static final String ARGKEY_USERSPASSWORDREMOVAL = "-userspasswordsremoval";
    private static final String ARGKEY_SQLSCRIPTFILEPATH = "-sqlscriptpath";
    private static final List<String> LIST_OF_MANDATORY_KEYS = new ArrayList<String>(Arrays.asList("-dbfolderpath", "-zipfilepath", "-dpdumpfolderpath", "-schemaname", "-oraclehostname"));

    private static void logUsageError(String errorMessage, String usageMessage) {
        LOGGER.error(MessageFormat.format("Usage error - {0}", errorMessage));
        LOGGER.error(usageMessage);
    }

    private static boolean isService(Map<String, String> m) {
        return m.keySet().stream().anyMatch(ARGKEY_ORACLESERVICE::equals);
    }

    public static int doRestore(String[] args) throws IOException, SQLException {
        String userName;
        TreeMap<String, String> mapOfOptionalArgumentDefaults = new TreeMap<String, String>();
        mapOfOptionalArgumentDefaults.put("-oracleadminaccountname", "SYSTEM");
        mapOfOptionalArgumentDefaults.put(ARGKEY_ORACLEPORT, "1521");
        mapOfOptionalArgumentDefaults.put(ARGKEY_USERSPASSWORDREMOVAL, "false");
        mapOfOptionalArgumentDefaults.put(ARGKEY_DPDUMPONLY, "false");
        mapOfOptionalArgumentDefaults.put(ARGKEY_SQLSCRIPTFILEPATH, null);
        mapOfOptionalArgumentDefaults.put(ARGKEY_DELETEDBFOLDER, "true");
        ArrayList<String> listOfValidKeys = new ArrayList<String>(LIST_OF_MANDATORY_KEYS);
        listOfValidKeys.addAll(mapOfOptionalArgumentDefaults.keySet());
        listOfValidKeys.add(ARGKEY_ORACLESID);
        listOfValidKeys.add(ARGKEY_ORACLESERVICE);
        listOfValidKeys.add("-oracleadminaccountpwd");
        listOfValidKeys.add("-oracleadminaccountpwdfile");
        StringBuilder sb = new StringBuilder();
        sb.append("Usage : DBRestoreCmd");
        LIST_OF_MANDATORY_KEYS.forEach(mandatoryKey -> sb.append(' ').append((String)mandatoryKey).append(' ').append("value"));
        if (!mapOfOptionalArgumentDefaults.isEmpty()) {
            sb.append(" [");
            mapOfOptionalArgumentDefaults.entrySet().forEach(optionalArgument -> sb.append(' ').append((String)optionalArgument.getKey()).append(' ').append((String)optionalArgument.getValue()));
            sb.append(" ]");
        }
        String usageMessage = sb.toString();
        TreeMap<String, String> mapOfArguments = new TreeMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            mapOfArguments.put(args[i], args[i + 1]);
            LOGGER.info(MessageFormat.format("main : Argument {0} {1}", args[i], args[i + 1]));
        }
        if (mapOfArguments.containsKey("-oracleadminaccountpwd") && mapOfArguments.containsKey("-oracleadminaccountpwdfile")) {
            String message = MessageFormat.format("Use {0} or {1}, both are defined", "-oracleadminaccountpwd", "-oracleadminaccountpwdfile");
            LOGGER.debug(message);
            DBRestoreCmd.logUsageError(message, usageMessage);
            return 1;
        }
        for (Map.Entry entry : mapOfArguments.entrySet()) {
            String argKey = (String)entry.getKey();
            LOGGER.debug(MessageFormat.format("main : Argument key ({0})", argKey));
            if (listOfValidKeys.contains(argKey)) continue;
            DBRestoreCmd.logUsageError(MessageFormat.format("Invalid argument key : ({0})", argKey), usageMessage);
            return 1;
        }
        for (String mandatoryKey2 : LIST_OF_MANDATORY_KEYS) {
            if (mapOfArguments.keySet().contains(mandatoryKey2)) continue;
            DBRestoreCmd.logUsageError(MessageFormat.format("Missing argument key : ({0})", mandatoryKey2), usageMessage);
            return 1;
        }
        mapOfOptionalArgumentDefaults.keySet().stream().filter(optionalKey -> mapOfArguments.get(optionalKey) == null).forEachOrdered(optionalKey -> mapOfArguments.put((String)optionalKey, (String)mapOfOptionalArgumentDefaults.get(optionalKey)));
        String deleteFolderOption = (String)mapOfArguments.get(ARGKEY_DELETEDBFOLDER);
        boolean deleteDbFolder = Boolean.valueOf(deleteFolderOption);
        String pathToZipFile = (String)mapOfArguments.get("-zipfilepath");
        String pathToDpdumpFolder = (String)mapOfArguments.get("-dpdumpfolderpath");
        String userPassword = userName = (String)mapOfArguments.get(ARGKEY_SCHEMANAME);
        String adminName = (String)mapOfArguments.get("-oracleadminaccountname");
        String adminPassword = CmdUtil.getAdminPwd(mapOfArguments);
        String userRole = "";
        String serverName = (String)mapOfArguments.get(ARGKEY_ORACLEHOSTNAME);
        String port = (String)mapOfArguments.get(ARGKEY_ORACLEPORT);
        String sidOrServiceName = DBRestoreCmd.isService(mapOfArguments) ? (String)mapOfArguments.get(ARGKEY_ORACLESERVICE) : (String)mapOfArguments.get(ARGKEY_ORACLESID);
        XmDbDef xmDbDef = new XmDbDef(serverName, port, sidOrServiceName, DBRestoreCmd.isService(mapOfArguments), userName, userPassword, adminName, adminPassword);
        String defaultTablespace = "USERS";
        String temporaryTablespace = "TEMP";
        String oracleUser = null;
        String dpdumpOnlyOption = (String)mapOfArguments.get(ARGKEY_DPDUMPONLY);
        boolean dpdumpOnly = Boolean.parseBoolean(dpdumpOnlyOption);
        String pathToDBFolder = dpdumpOnly ? Paths.get(Files.createTempDirectory("tempFolder", new FileAttribute[0]).toString(), "temp").toString() : (String)mapOfArguments.get("-dbfolderpath");
        Map<String, String> dbInfosProperties = null;
        String usersPasswordsRemovalOption = (String)mapOfArguments.get(ARGKEY_USERSPASSWORDREMOVAL);
        Boolean usersPasswordsRemoval = Boolean.valueOf(usersPasswordsRemovalOption);
        String pathToSQLScript = (String)mapOfArguments.get(ARGKEY_SQLSCRIPTFILEPATH);
        RestoreActionDef restoreActionDef = new RestoreActionDef(pathToZipFile, new CmdExecutionObserver(), pathToDpdumpFolder, dpdumpOnly, pathToDBFolder, deleteDbFolder, xmDbDef, "", "USERS", "TEMP", oracleUser, dbInfosProperties, usersPasswordsRemoval, pathToSQLScript);
        RestoreService.restore(restoreActionDef);
        if (dpdumpOnly) {
            Files.delete(Paths.get(pathToDBFolder, new String[0]).getParent());
        }
        return restoreActionDef.getActionStatus();
    }

    public static void main(String[] args) {
        LOGGER.debug("main : Starting");
        int restoreActionStatus = 1;
        try {
            restoreActionStatus = DBRestoreCmd.doRestore(args);
        }
        catch (IOException | SQLException ex) {
            LOGGER.error("Error while restoring", ex);
        }
        LOGGER.debug("main : ended");
        System.exit(restoreActionStatus);
    }
}

