/*
 * Decompiled with CFR 0.152.
 */
package db.manager.cmd;

import db.manager.cmd.CmdExecutionObserver;
import db.manager.cmd.CmdUtil;
import db.manager.constant.database.XmDbDef;
import db.manager.datasource.DataSourceUtil;
import db.manager.exec.save.SaveActionDef;
import db.manager.exec.save.SaveService;
import db.manager.properties.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DBSaveCmd {
    private static final Logger LOGGER = Logger.getLogger(DBSaveCmd.class);
    private static final String ARGKEY_SQLSCRIPTFILEPATH = "-sqlscriptpath";
    private static final String ARGKEY_DPDUMPONLY = "-dpdumponly";
    private static final String ARGKEY_SAVEWEBAPPS = "-savewebapps";
    private static final String ARGKEY_SAVEJRE = "-savejre";
    private static final List<String> LIST_OF_MANDATORY_KEYS = new ArrayList<String>(Arrays.asList("-dbfolderpath", "-zipfilepath", "-dpdumpfolderpath"));

    private static void logUsageError(String errorMessage, String usageMessage) {
        LOGGER.error(MessageFormat.format("Usage error - {0}", errorMessage));
        LOGGER.error(usageMessage);
    }

    public static int doSave(String[] args) throws IOException, SQLException {
        TreeMap<String, String> mapOfOptionalArgumentDefaults = new TreeMap<String, String>();
        mapOfOptionalArgumentDefaults.put("-oracleadminaccountname", "SYSTEM");
        mapOfOptionalArgumentDefaults.put(ARGKEY_SQLSCRIPTFILEPATH, null);
        mapOfOptionalArgumentDefaults.put(ARGKEY_DPDUMPONLY, "false");
        mapOfOptionalArgumentDefaults.put(ARGKEY_SAVEWEBAPPS, "true");
        mapOfOptionalArgumentDefaults.put(ARGKEY_SAVEJRE, "true");
        ArrayList<String> listOfValidKeys = new ArrayList<String>(LIST_OF_MANDATORY_KEYS);
        listOfValidKeys.addAll(mapOfOptionalArgumentDefaults.keySet());
        listOfValidKeys.add("-oracleadminaccountpwd");
        listOfValidKeys.add("-oracleadminaccountpwdfile");
        StringBuilder sb = new StringBuilder();
        sb.append("Usage : DBSaveCmd");
        LIST_OF_MANDATORY_KEYS.forEach(mandatoryKey -> sb.append(' ').append((String)mandatoryKey).append(' ').append("value"));
        if (!mapOfOptionalArgumentDefaults.isEmpty()) {
            sb.append(" [");
            mapOfOptionalArgumentDefaults.entrySet().forEach(optionalArgument -> sb.append(' ').append((String)optionalArgument.getKey()).append(' ').append((String)optionalArgument.getValue()));
            sb.append(" ]");
        }
        String usageMessage = sb.toString();
        int lengthOfArgs = args.length;
        if (lengthOfArgs < LIST_OF_MANDATORY_KEYS.size() * 2) {
            DBSaveCmd.logUsageError(MessageFormat.format("Wrong number of arguments ({0} at least are expected)", LIST_OF_MANDATORY_KEYS.size() * 2), usageMessage);
            return 1;
        }
        TreeMap<String, String> mapOfArguments = new TreeMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            mapOfArguments.put(args[i], args[i + 1]);
            LOGGER.info(MessageFormat.format("main : Argument {0} {1}", args[i], args[i + 1]));
        }
        if (mapOfArguments.containsKey("-oracleadminaccountpwd") && mapOfArguments.containsKey("-oracleadminaccountpwdfile")) {
            String message = MessageFormat.format("Use {0} or {1}, both are defined", "-oracleadminaccountpwd", "-oracleadminaccountpwdfile");
            LOGGER.debug(message);
            DBSaveCmd.logUsageError(message, usageMessage);
            return 1;
        }
        for (Map.Entry entry : mapOfArguments.entrySet()) {
            String argKey = (String)entry.getKey();
            LOGGER.debug(MessageFormat.format("main : Argument key ({0})", argKey));
            if (listOfValidKeys.contains(argKey)) continue;
            DBSaveCmd.logUsageError(MessageFormat.format("Invalid argument key : ({0})", argKey), usageMessage);
            return 1;
        }
        for (String mandatoryKey2 : LIST_OF_MANDATORY_KEYS) {
            if (mapOfArguments.keySet().contains(mandatoryKey2)) continue;
            DBSaveCmd.logUsageError(MessageFormat.format("Missing argument key : ({0})", mandatoryKey2), usageMessage);
            return 1;
        }
        mapOfOptionalArgumentDefaults.keySet().stream().filter(optionalKey -> mapOfArguments.get(optionalKey) == null).forEachOrdered(optionalKey -> mapOfArguments.put((String)optionalKey, (String)mapOfOptionalArgumentDefaults.get(optionalKey)));
        String pathToDBFolder = (String)mapOfArguments.get("-dbfolderpath");
        File dbConfigsFolder = new File(pathToDBFolder, "configs");
        File dbinfosFile = new File(dbConfigsFolder, "db_infos.xml");
        Properties propertiesFromDBInfos = PropertiesUtil.loadPropertiesFromXMLFileEx(dbinfosFile);
        String userName = propertiesFromDBInfos.getProperty("SCHEMA");
        String userPassword = propertiesFromDBInfos.getProperty("SCHEMA_PWD", userName);
        String adminName = (String)mapOfArguments.get("-oracleadminaccountname");
        String adminPassword = CmdUtil.getAdminPwd(mapOfArguments);
        String userRole = propertiesFromDBInfos.getProperty("ROLE", userName + "_ROLE");
        String databaseJDBCURL = propertiesFromDBInfos.getProperty("JDBC");
        XmDbDef xmDbDef = DataSourceUtil.extractFromUrl(databaseJDBCURL, userName, userPassword, adminName, adminPassword);
        String pathToZipFile = (String)mapOfArguments.get("-zipfilepath");
        String pathToDpdumpFolder = (String)mapOfArguments.get("-dpdumpfolderpath");
        String pathToSQLScript = (String)mapOfArguments.get(ARGKEY_SQLSCRIPTFILEPATH);
        String dpdumpOnlyOption = (String)mapOfArguments.get(ARGKEY_DPDUMPONLY);
        Boolean dpdumpOnly = Boolean.valueOf(dpdumpOnlyOption);
        String saveWebAppsOption = (String)mapOfArguments.get(ARGKEY_SAVEWEBAPPS);
        Boolean saveWebApps = Boolean.valueOf(saveWebAppsOption);
        String saveJreOption = (String)mapOfArguments.get(ARGKEY_SAVEJRE);
        Boolean saveJre = Boolean.valueOf(saveJreOption);
        SaveActionDef saveActionDef = new SaveActionDef(pathToZipFile, new CmdExecutionObserver(), pathToDpdumpFolder, pathToDBFolder, xmDbDef, userRole, pathToSQLScript, dpdumpOnly, saveWebApps, saveJre);
        SaveService.save(saveActionDef);
        return saveActionDef.getActionStatus();
    }

    public static void main(String[] args) {
        LOGGER.debug("main : Starting");
        int saveActionStatus = 1;
        try {
            saveActionStatus = DBSaveCmd.doSave(args);
        }
        catch (IOException | SQLException ex) {
            LOGGER.error("Error while saving", ex);
        }
        int exitStatus = saveActionStatus == 1 ? 1 : 0;
        LOGGER.debug(String.format("main : Ended (exit status %d)", exitStatus));
        System.exit(exitStatus);
    }
}

