@HEADER@

DECLARE
  p_SRC_SCHEMA varchar2(30) := '@SRC_SCHEMA@'; 
  p_TGT_SCHEMA varchar2(30) := '@TGT_SCHEMA@'; 
  --  
  ind NUMBER;              -- Loop index
  h1 NUMBER;               -- Data Pump job handle
  percent_done NUMBER;     -- Percentage of job complete
  job_state VARCHAR2(30);  -- To keep track of job state
  le ku$_LogEntry;         -- For WIP and error messages
  js ku$_JobStatus;        -- The job status from get_status
  jd ku$_JobDesc;          -- The job description from get_status
  sts ku$_Status;          -- The status object returned by get_status
BEGIN
-- Create a (user-named) Data Pump job to do a schema export.

  h1 := DBMS_DATAPUMP.OPEN(operation   => 'IMPORT',
                           job_mode    => 'SCHEMA',
                           remote_link => NULL);
  -- http://download.oracle.com/docs/cd/E11882_01/appdev.112/e25788/d_datpmp.htm#i997806						   
  -- job_name =>, version =>  

-- Specify a single dump file for the job (using the handle just returned)
-- and a directory object, which must already be defined and accessible
-- to the user running this procedure.

  DBMS_DATAPUMP.ADD_FILE(h1, p_TGT_SCHEMA || '.dmp','DATA_PUMP_DIR', filetype => 1); --KU$_FILE_TYPE_DUMP_FILE);

  DBMS_DATAPUMP.ADD_FILE(h1, p_TGT_SCHEMA || '.log','DATA_PUMP_DIR', filetype => 3); --KU$_FILE_TYPE_LOG_FILE);

-- A metadata filter is used to specify what will be imported
  DBMS_DATAPUMP.METADATA_FILTER(h1, 'SCHEMA_EXPR',       VALUE => 'IN (''' || p_SRC_SCHEMA || ''')');
  DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => '=''ROLE_GRANT''');
  DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => '=''SYSTEM_GRANT''');
  DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => '=''DEFAULT_ROLE''');
  DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => '=''GRANT''');
  --DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => 'like ''%GRANT''');

  --DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => '=''TABLE_DATA''') ;
  --DBMS_DATAPUMP.METADATA_FILTER(h1, 'EXCLUDE_PATH_EXPR', VALUE => '=''TABLE_DATA:"IN (''''XM_DOCUMENT_BLOB_CACHE'''')"''') ;
  --  Ce qui fonctionne en ligne de commande : EXCLUDE=STATISTICS,TABLE_DATA:IN('XM_DOCUMENT_BLOB_CACHE')

  
  DBMS_DATAPUMP.METADATA_REMAP (h1, 'REMAP_SCHEMA', old_value => p_SRC_SCHEMA, value => p_TGT_SCHEMA);
  
  -- http://psoug.org/reference/dbms_datapump.html
  DBMS_DATAPUMP.METADATA_TRANSFORM (h1, 'SEGMENT_ATTRIBUTES', VALUE=> 0);
  DBMS_DATAPUMP.METADATA_TRANSFORM (h1, 'OID',                VALUE=> 0);

-- Start the job. An exception will be generated if something is not set up
-- properly.

  DBMS_DATAPUMP.START_JOB(h1);

-- The export job should now be running. In the following loop, the job
-- is monitored until it completes. In the meantime, progress information is
-- displayed.

  percent_done := 0;
  job_state := 'UNDEFINED';
  while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop
    dbms_datapump.get_status(h1,
           dbms_datapump.ku$_status_job_error +
           dbms_datapump.ku$_status_job_status +
           dbms_datapump.ku$_status_wip,-1,job_state,sts);
    js := sts.job_status;

-- If the percentage done changed, display the new value.

    -- if js.percent_done != percent_done
    -- then
    --   dbms_output.put_line('*** Job percent done = ' ||
    --                        to_char(js.percent_done));
    --   percent_done := js.percent_done;
    -- end if;

-- If any work-in-progress (WIP) or error messages were received for the job,
-- display them.

   if (bitand(sts.mask,dbms_datapump.ku$_status_wip) != 0)
    then
      le := sts.wip;
    else
      if (bitand(sts.mask,dbms_datapump.ku$_status_job_error) != 0)
      then
        le := sts.error;
      else
        le := null;
      end if;
    end if;
    if le is not null
    then
      ind := le.FIRST;
      while ind is not null loop
        dbms_output.put_line(le(ind).LogText);
        ind := le.NEXT(ind);
      end loop;
    end if;
  end loop;

-- Indicate that the job finished and detach from it.

  dbms_output.put_line('Job has completed');
  dbms_output.put_line('Final job state = ' || job_state);
  dbms_datapump.detach(h1);
END;
/
