/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.DATE;

abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS;
    static final int[] LEAP_NUM_DAYS;
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
    }

    DateTimeCommonAccessor() {
    }

    static long calculateEpochOffset(TimeZone timeZone) {
        return DateTimeCommonAccessor.zoneOffset(timeZone, 1970, 0, 1, 5, 0);
    }

    static final long computeJulianDay(boolean bl, int n, int n2, int n3) {
        boolean bl2 = n % 4 == 0;
        int n4 = n - 1;
        long l = 365L * (long)n4 + DateTimeCommonAccessor.floorDivide(n4, 4L) + 1721423L;
        if (bl) {
            bl2 = bl2 && (n % 100 != 0 || n % 400 == 0);
            l += DateTimeCommonAccessor.floorDivide(n4, 400L) - DateTimeCommonAccessor.floorDivide(n4, 100L) + 2L;
        }
        return l + (long)n3 + (long)(bl2 ? LEAP_NUM_DAYS[n2] : NUM_DAYS[n2]);
    }

    static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    DATE getDATE(int n) throws SQLException {
        DATE dATE = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[7];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, 7);
            dATE = new DATE(byArray);
        }
        return dATE;
    }

    Date getDate(int n) throws SQLException {
        Date date;
        block4: {
            date = null;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block4;
            int n2 = this.columnIndex + this.byteLength * n;
            TimeZone timeZone = this.stmt.getDefaultTimeZone();
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            if (n3 <= 0) {
                ++n3;
            }
            try {
                date = new Date(DateTimeCommonAccessor.getMillis(n3, this.oracleMonth(n2), this.oracleDay(n2), 0, timeZone));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                DatabaseError.throwSqlException(132);
            }
        }
        return date;
    }

    Date getDate(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getDate(n);
        }
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            calendar.set(1, n3);
            calendar.set(2, this.oracleMonth(n2));
            calendar.set(5, this.oracleDay(n2));
            calendar.set(11, this.oracleHour(n2));
            calendar.set(12, this.oracleMin(n2));
            calendar.set(13, this.oracleSec(n2));
            calendar.set(14, 0);
            date = new Date(calendar.getTime().getTime());
        }
        return date;
    }

    static long getMillis(int n, int n2, int n3, int n4, TimeZone timeZone) {
        long l;
        long l2;
        boolean bl = n >= 1582;
        if (bl != (l2 = ((l = DateTimeCommonAccessor.computeJulianDay(bl, n, n2, n3)) - 2440588L) * 86400000L) >= -12219292800000L) {
            l = DateTimeCommonAccessor.computeJulianDay(bl ^ true, n, n2, n3);
            l2 = (l - 2440588L) * 86400000L;
        }
        return (l2 += (long)n4) - DateTimeCommonAccessor.zoneOffset(timeZone, n, n2, n3, DateTimeCommonAccessor.julianDayToDayOfWeek(l), n4);
    }

    Time getTime(int n) throws SQLException {
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            TimeZone timeZone = this.stmt.getDefaultTimeZone();
            if (timeZone != epochTimeZone) {
                epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(timeZone);
                epochTimeZone = timeZone;
            }
            time = new Time((long)this.oracleTime(n2) - epochTimeZoneOffset);
        }
        return time;
    }

    Time getTime(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTime(n);
        }
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, this.oracleHour(n2));
            calendar.set(12, this.oracleMin(n2));
            calendar.set(13, this.oracleSec(n2));
            calendar.set(14, 0);
            time = new Time(calendar.getTime().getTime());
        }
        return time;
    }

    Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestamp(n);
        }
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            calendar.set(1, n3);
            calendar.set(2, this.oracleMonth(n2));
            calendar.set(5, this.oracleDay(n2));
            calendar.set(11, this.oracleHour(n2));
            calendar.set(12, this.oracleMin(n2));
            calendar.set(13, this.oracleSec(n2));
            calendar.set(14, 0);
            timestamp = new Timestamp(calendar.getTime().getTime());
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            if (s >= 11) {
                timestamp.setNanos(this.oracleNanos(n2));
            }
        }
        return timestamp;
    }

    static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    final int oracleDay(int n) {
        return this.rowSpaceByte[3 + n];
    }

    final int oracleHour(int n) {
        return this.rowSpaceByte[4 + n] - 1;
    }

    final int oracleMin(int n) {
        return this.rowSpaceByte[5 + n] - 1;
    }

    final int oracleMonth(int n) {
        return this.rowSpaceByte[2 + n] - 1;
    }

    final int oracleNanos(int n) {
        int n2 = (this.rowSpaceByte[7 + n] & 0xFF) << 24;
        n2 |= (this.rowSpaceByte[8 + n] & 0xFF) << 16;
        n2 |= (this.rowSpaceByte[9 + n] & 0xFF) << 8;
        return n2 |= this.rowSpaceByte[10 + n] & 0xFF & 0xFF;
    }

    final int oracleSec(int n) {
        return this.rowSpaceByte[6 + n] - 1;
    }

    final int oracleTZ1(int n) {
        return this.rowSpaceByte[11 + n];
    }

    final int oracleTZ2(int n) {
        return this.rowSpaceByte[12 + n];
    }

    final int oracleTime(int n) {
        int n2 = this.oracleHour(n);
        n2 *= 60;
        n2 += this.oracleMin(n);
        n2 *= 60;
        n2 += this.oracleSec(n);
        return n2 *= 1000;
    }

    final int oracleYear(int n) {
        int n2 = ((this.rowSpaceByte[n] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n] & 0xFF) - 100;
        return n2 <= 0 ? n2 + 1 : n2;
    }

    static final long zoneOffset(TimeZone timeZone, int n, int n2, int n3, int n4, int n5) {
        return timeZone.getOffset(n < 0 ? 0 : 1, n, n2, n3, n4, n5);
    }
}

