/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

class FDBigInt {
    int nWords;
    int[] data;

    FDBigInt(int n) {
        this.nWords = 1;
        this.data = new int[1];
        this.data[0] = n;
    }

    FDBigInt(long l) {
        this.data = new int[2];
        this.data[0] = (int)l;
        this.data[1] = (int)(l >>> 32);
        this.nWords = this.data[1] == 0 ? 1 : 2;
    }

    FDBigInt(FDBigInt fDBigInt) {
        this.nWords = fDBigInt.nWords;
        this.data = new int[this.nWords];
        System.arraycopy(fDBigInt.data, 0, this.data, 0, this.nWords);
    }

    FDBigInt(int[] nArray, int n) {
        this.data = nArray;
        this.nWords = n;
    }

    FDBigInt add(FDBigInt fDBigInt) {
        int n;
        int[] nArray;
        int n2;
        int[] nArray2;
        long l = 0L;
        if (this.nWords >= fDBigInt.nWords) {
            nArray2 = this.data;
            n2 = this.nWords;
            nArray = fDBigInt.data;
            n = fDBigInt.nWords;
        } else {
            nArray2 = fDBigInt.data;
            n2 = fDBigInt.nWords;
            nArray = this.data;
            n = this.nWords;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            l += (long)nArray2[n3] & 0xFFFFFFFFL;
            if (n3 < n) {
                l += (long)nArray[n3] & 0xFFFFFFFFL;
            }
            nArray3[n3] = (int)l;
            l >>= 32;
            ++n3;
        }
        if (l != 0L) {
            int[] nArray4 = new int[nArray3.length + 1];
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
            nArray4[n3++] = (int)l;
            return new FDBigInt(nArray4, n3);
        }
        return new FDBigInt(nArray3, n3);
    }

    int cmp(FDBigInt fDBigInt) {
        int n;
        int n2;
        if (this.nWords > fDBigInt.nWords) {
            n2 = fDBigInt.nWords - 1;
            n = this.nWords - 1;
            while (n > n2) {
                if (this.data[n] != 0) {
                    return 1;
                }
                --n;
            }
        } else if (this.nWords < fDBigInt.nWords) {
            n2 = this.nWords - 1;
            n = fDBigInt.nWords - 1;
            while (n > n2) {
                if (fDBigInt.data[n] != 0) {
                    return -1;
                }
                --n;
            }
        } else {
            n = this.nWords - 1;
        }
        while (n > 0) {
            if (this.data[n] != fDBigInt.data[n]) break;
            --n;
        }
        n2 = this.data[n];
        int n3 = fDBigInt.data[n];
        if (n2 < 0) {
            if (n3 < 0) {
                return n2 - n3;
            }
            return 1;
        }
        if (n3 < 0) {
            return -1;
        }
        return n2 - n3;
    }

    void lshiftMe(int n) throws IllegalArgumentException {
        if (n <= 0) {
            if (n == 0) {
                return;
            }
            throw new IllegalArgumentException("negative shift count");
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = 32 - n3;
        int[] nArray = this.data;
        int[] nArray2 = this.data;
        if (this.nWords + n2 + 1 > nArray.length) {
            nArray = new int[this.nWords + n2 + 1];
        }
        int n5 = this.nWords + n2;
        int n6 = this.nWords - 1;
        if (n3 == 0) {
            System.arraycopy(nArray2, 0, nArray, n2, this.nWords);
            n5 = n2 - 1;
        } else {
            nArray[n5--] = nArray2[n6] >>> n4;
            while (n6 >= 1) {
                nArray[n5--] = nArray2[n6] << n3 | nArray2[--n6] >>> n4;
            }
            nArray[n5--] = nArray2[n6] << n3;
        }
        while (n5 >= 0) {
            nArray[n5--] = 0;
        }
        this.data = nArray;
        this.nWords += n2 + 1;
        while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
            --this.nWords;
        }
    }

    FDBigInt mult(int n) {
        long l = n;
        int[] nArray = new int[l * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
        long l2 = 0L;
        int n2 = 0;
        while (n2 < this.nWords) {
            nArray[n2] = (int)(l2 += l * ((long)this.data[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
            ++n2;
        }
        if (l2 == 0L) {
            return new FDBigInt(nArray, this.nWords);
        }
        nArray[this.nWords] = (int)l2;
        return new FDBigInt(nArray, this.nWords + 1);
    }

    FDBigInt mult(FDBigInt fDBigInt) {
        int[] nArray = new int[this.nWords + fDBigInt.nWords];
        int n = 0;
        while (n < this.nWords) {
            long l = (long)this.data[n] & 0xFFFFFFFFL;
            long l2 = 0L;
            int n2 = 0;
            while (n2 < fDBigInt.nWords) {
                nArray[n + n2] = (int)(l2 += ((long)nArray[n + n2] & 0xFFFFFFFFL) + l * ((long)fDBigInt.data[n2] & 0xFFFFFFFFL));
                l2 >>>= 32;
                ++n2;
            }
            nArray[n + n2] = (int)l2;
            ++n;
        }
        n = nArray.length - 1;
        while (n > 0) {
            if (nArray[n] != 0) break;
            --n;
        }
        return new FDBigInt(nArray, n + 1);
    }

    /*
     * Unable to fully structure code
     */
    int normalizeMe() throws IllegalArgumentException {
        block6: {
            var2_1 = 0;
            var3_2 = 0;
            var4_3 = 0;
            var1_4 = this.nWords - 1;
            while (var1_4 >= 0 && (var4_3 = this.data[var1_4]) == 0) {
                ++var2_1;
                --var1_4;
            }
            if (var1_4 < 0) {
                throw new IllegalArgumentException("zero value");
            }
            this.nWords -= var2_1;
            if ((var4_3 & -268435456) == 0) ** GOTO lbl21
            var3_2 = 32;
            while ((var4_3 & -268435456) != 0) {
                var4_3 >>>= 1;
                --var3_2;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                var4_3 <<= 8;
                var3_2 += 8;
lbl21:
                // 2 sources

                ** while (var4_3 <= 1048575)
            }
lbl22:
            // 2 sources

            while (var4_3 <= 0x7FFFFFF) {
                var4_3 <<= 1;
                ++var3_2;
            }
        }
        if (var3_2 != 0) {
            this.lshiftMe(var3_2);
        }
        return var3_2;
    }

    int quoRemIteration(FDBigInt fDBigInt) throws IllegalArgumentException {
        int n;
        long l;
        if (this.nWords != fDBigInt.nWords) {
            throw new IllegalArgumentException("disparate values");
        }
        int n2 = this.nWords - 1;
        long l2 = ((long)this.data[n2] & 0xFFFFFFFFL) / (long)fDBigInt.data[n2];
        long l3 = 0L;
        int n3 = 0;
        while (n3 <= n2) {
            this.data[n3] = (int)(l3 += ((long)this.data[n3] & 0xFFFFFFFFL) - l2 * ((long)fDBigInt.data[n3] & 0xFFFFFFFFL));
            l3 >>= 32;
            ++n3;
        }
        if (l3 != 0L) {
            l = 0L;
            while (l == 0L) {
                l = 0L;
                n = 0;
                while (n <= n2) {
                    this.data[n] = (int)(l += ((long)this.data[n] & 0xFFFFFFFFL) + ((long)fDBigInt.data[n] & 0xFFFFFFFFL));
                    l >>= 32;
                    ++n;
                }
                if (l != 0L && l != 1L) {
                    throw new RuntimeException("Assertion botch: " + l + " carry out of division correction");
                }
                --l2;
            }
        }
        l = 0L;
        n = 0;
        while (n <= n2) {
            this.data[n] = (int)(l += 10L * ((long)this.data[n] & 0xFFFFFFFFL));
            l >>= 32;
            ++n;
        }
        if (l != 0L) {
            throw new RuntimeException("Assertion botch: carry out of *10");
        }
        return (int)l2;
    }
}

