/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;

public class OracleSavepoint
implements oracle.jdbc.OracleSavepoint {
    private static final int MAX_ID_VALUE = 65535;
    private static final int INVALID_ID_VALUE = -1;
    static final int NAMED_SAVEPOINT_TYPE = 2;
    static final int UNNAMED_SAVEPOINT_TYPE = 1;
    static final int UNKNOWN_SAVEPOINT_TYPE = 0;
    private static int s_seedId = 0;
    private int m_id = -1;
    private String m_name = null;
    private int m_type = 0;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    OracleSavepoint() {
        this.m_type = 1;
        this.m_id = this.getNextId();
        this.m_name = null;
    }

    OracleSavepoint(String string) {
        this.m_type = 2;
        this.m_name = string;
        this.m_id = -1;
    }

    private synchronized int getNextId() {
        s_seedId = (s_seedId + 1) % 65535;
        return s_seedId;
    }

    public int getSavepointId() throws SQLException {
        if (this.m_type == 2) {
            DatabaseError.throwSqlException(118);
        }
        return this.m_id;
    }

    public String getSavepointName() throws SQLException {
        if (this.m_type == 1) {
            DatabaseError.throwSqlException(119);
        }
        return this.m_name;
    }

    int getType() {
        return this.m_type;
    }
}

