/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;

abstract class PhysicalConnection
extends OracleConnection {
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    String url;
    String user;
    String save_user;
    String password;
    String database;
    boolean auto_commit;
    String protocol;
    int m_streamChunkSize = 16384;
    public int protocolId = -3;
    OracleTimeout timeout;
    DBConversion conversion;
    boolean XA_wants_error;
    boolean UsingXA;
    int m_txn_mode = 0;
    byte[] fdo;
    Boolean big_endian;
    OracleStatement statements;
    int lifecycle;
    static final byte OPEN = 1;
    static final byte CLOSING = 2;
    static final byte CLOSED = 4;
    static final byte ABORTED = 8;
    boolean m_clientIdSet = false;
    String m_clientId = null;
    int default_batch;
    int default_row_prefetch;
    boolean report_remarks;
    boolean include_synonyms = false;
    boolean restrict_getTables = false;
    boolean m_accumulateBatchResult = true;
    boolean m_j2ee13Compliant = false;
    int trans_level;
    Map map;
    Map m_javaObjectMap;
    Hashtable descriptorCache;
    OracleStatement statement_holding_line;
    oracle.jdbc.OracleDatabaseMetaData m_dbMetaData = null;
    LogicalConnection logicalConnectionAttached;
    boolean is_proxy = false;
    boolean useFetchSizeWithLongColumn = false;
    OracleSql m_osql = null;
    SQLWarning m_warning = null;
    boolean m_readOnly = false;
    LRUStatementCache statementCache = null;
    boolean m_stmtClearMetaData = false;
    boolean m_process_escapes = true;
    boolean m_defaultAutoRefetch = true;
    OracleCloseCallback m_occ = null;
    Object m_privData = null;
    boolean defaultFixedString = false;
    boolean defaultNChar = false;
    Statement m_svptStmt = null;
    static final int[] endToEndMaxLength = new int[4];
    boolean endToEndAnyChanged = false;
    final boolean[] endToEndHasChanged = new boolean[4];
    short endToEndECIDSequenceNumber = Short.MIN_VALUE;
    String[] endToEndValues = null;
    final boolean useDMSForEndToEnd = this.endToEndValues != null;
    oracle.jdbc.OracleConnection wrapper = null;
    Properties connectionProperties = null;
    boolean wellBehavedStatementReuse = false;
    int min_binary_stream_size;
    int min_ascii_stream_size;
    int min_vcs_bind_size;
    OracleDriverExtension driverExtension;
    static final String uninitializedMarker = "";
    String databaseProductVersion = "";
    short versionNumber = (short)-1;
    boolean m_v8Compatible;
    boolean looseTimestampDateCheck = false;
    String ressourceManagerId = "0000";
    boolean isMemoryFreedOnEnteringCache = false;
    int namedTypeAccessorByteLen;
    int refTypeAccessorByteLen;
    boolean disableDefineColumnType = false;
    CharacterSet setCHARCharSetObj;
    CharacterSet setCHARNCharSetObj;
    boolean plsqlCompilerWarnings = false;
    static boolean m_traceEnabled;
    Hashtable m_clientData;
    String m_sessionTimeZone = null;
    Calendar m_dbTzCalendar = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    static {
        PhysicalConnection.endToEndMaxLength[0] = 32;
        PhysicalConnection.endToEndMaxLength[1] = 64;
        PhysicalConnection.endToEndMaxLength[2] = 64;
        PhysicalConnection.endToEndMaxLength[3] = 48;
        m_traceEnabled = false;
        _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    }

    PhysicalConnection() {
    }

    PhysicalConnection(String string, String string2, String string3, String string4, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        String string5;
        this.driverExtension = oracleDriverExtension;
        String string6 = null;
        if (properties != null) {
            string6 = (String)((Hashtable)properties).get("protocol");
            String string7 = properties.getProperty("processEscapes");
            if (string7 != null && string7.equalsIgnoreCase("false")) {
                this.m_process_escapes = false;
            }
            if ((string5 = (String)((Hashtable)properties).get("RessourceManagerId")) != null) {
                this.ressourceManagerId = string5;
            }
            this.connectionProperties = (Properties)((Hashtable)properties).clone();
            ((Hashtable)this.connectionProperties).remove("password");
        }
        this.password = string3;
        this.initialize(string, string2, string6, null, null, null, string4);
        this.logicalConnectionAttached = null;
        try {
            String string8;
            this.needLine();
            this.logon();
            boolean bl = true;
            if (properties != null) {
                string5 = properties.getProperty("autoCommit");
                if (string5 != null && string5.equalsIgnoreCase("false")) {
                    bl = false;
                }
                if ((string5 = this.connectionProperties.getProperty("wellBehavedStatementReuse")) != null && string5.equalsIgnoreCase("true")) {
                    this.wellBehavedStatementReuse = true;
                }
            }
            this.setAutoCommit(bl);
            if (this.getVersionNumber() >= 8000) {
                this.min_binary_stream_size = 2000;
                this.min_ascii_stream_size = 4000;
                this.min_vcs_bind_size = 4001;
            } else {
                this.min_binary_stream_size = 255;
                this.min_ascii_stream_size = 2000;
                this.min_vcs_bind_size = 2001;
            }
            String string9 = string5 = properties != null ? properties.getProperty("oracle.jdbc.V8Compatible") : null;
            if (string5 == null) {
                string5 = OracleDriver.getSystemProperty("oracle.jdbc.V8Compatible");
            }
            if (string5 != null) {
                this.m_v8Compatible = string5.equalsIgnoreCase("true");
            }
            String string10 = string8 = properties != null ? properties.getProperty("oracle.jdbc.StreamChunkSize") : null;
            if (string8 != null) {
                this.m_streamChunkSize = Math.max(4096, Integer.parseInt(string8));
            }
            String string11 = string8 = properties != null ? properties.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch") : null;
            if (string8 != null && string8.equalsIgnoreCase("true")) {
                this.looseTimestampDateCheck = true;
            }
            string8 = properties != null ? properties.getProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache") : null;
            this.isMemoryFreedOnEnteringCache = string8 != null && string8.equalsIgnoreCase("true");
            this.initializeSetCHARCharSetObjs();
        }
        catch (SQLException sQLException) {
            try {
                this.logoff();
            }
            catch (SQLException sQLException2) {}
            throw sQLException;
        }
        this.m_txn_mode = 0;
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int[] nArray = new int[]{n};
        return this.conversion.CHARBytesToJavaChars(byArray, 0, cArray, 0, nArray, cArray.length);
    }

    public boolean IsNCharFixedWith() {
        return this.conversion.IsNCharFixedWith();
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int[] nArray = new int[1];
        return this.conversion.NCHARBytesToJavaChars(byArray, 0, cArray, 0, nArray, cArray.length);
    }

    abstract OracleStatement RefCursorBytesToStatement(byte[] var1, OracleStatement var2) throws SQLException;

    public synchronized Connection _getPC() {
        return null;
    }

    static oracle.jdbc.internal.OracleConnection _physicalConnectionWithin(Connection connection) {
        OracleConnection oracleConnection = null;
        if (connection != null) {
            oracleConnection = PhysicalConnection.unwrapCompletely((oracle.jdbc.OracleConnection)connection);
        }
        return oracleConnection;
    }

    public void abort() throws SQLException {
        if (this.lifecycle == 4 || this.lifecycle == 8) {
            return;
        }
        this.lifecycle = 8;
        this.doAbort();
    }

    void addClassMapEntry(String string, String string2, Map map) {
        if (OracleConnection.containsKey(map, string)) {
            return;
        }
        try {
            Class clazz = this.safelyGetClassForName(string2);
            map.put(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    void addDefaultClassMapEntriesTo(Map map) {
        if (map != null) {
            this.addClassMapEntry("SYS.XMLTYPE", "oracle.xdb.XMLTypeFactory", map);
        }
    }

    synchronized void add_statement(OracleStatement oracleStatement) {
        if (oracleStatement.next != null) {
            throw new Error("add_statement called twice on " + oracleStatement);
        }
        oracleStatement.next = this.statements;
        if (this.statements != null) {
            this.statements.prev = oracleStatement;
        }
        this.statements = oracleStatement;
    }

    public synchronized void applyConnectionAttributes(Properties properties) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
    }

    public synchronized void cacheExplicitStatement(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        if (this.statementCache == null) {
            DatabaseError.throwSqlException(95);
        } else {
            this.statementCache.addToExplicitCache(oraclePreparedStatement, string);
        }
    }

    public synchronized void cacheImplicitStatement(OraclePreparedStatement oraclePreparedStatement, String string, int n, int n2) throws SQLException {
        if (this.statementCache == null) {
            DatabaseError.throwSqlException(95);
        } else {
            this.statementCache.addToImplicitCache(oraclePreparedStatement, string, n, n2);
        }
    }

    public void cancel() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleStatement oracleStatement = this.statements;
        while (oracleStatement != null) {
            try {
                oracleStatement.cancel();
            }
            catch (SQLException sQLException) {}
            oracleStatement = oracleStatement.next;
        }
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return Class.forName(string);
    }

    void cleanup() {
        this.fdo = null;
        this.conversion = null;
        this.statements = null;
        this.descriptorCache = null;
        this.map = null;
        this.m_javaObjectMap = null;
        this.statement_holding_line = null;
        this.m_osql = null;
        this.is_proxy = false;
    }

    public void clearClientIdentifier(String string) throws SQLException {
        String[] stringArray;
        if (!this.useDMSForEndToEnd && string != null && string != uninitializedMarker && (stringArray = this.getEndToEndMetrics()) != null && string.equals(stringArray[1])) {
            stringArray[1] = null;
            this.setEndToEndMetrics(stringArray, this.getEndToEndECIDSequenceNumber());
        }
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public synchronized void close() throws SQLException {
        block7: {
            if (this.lifecycle == 2 || this.lifecycle == 4) {
                return;
            }
            if (this.lifecycle == 1) {
                this.lifecycle = 2;
            }
            try {
                if (this.m_occ != null) {
                    this.m_occ.beforeClose(this, this.m_privData);
                }
                this.close_statements(true);
                this.needLine();
                if (this.is_proxy) {
                    this.close(1);
                }
                this.logoff();
                this.cleanup();
                if (this.timeout != null) {
                    this.timeout.close();
                }
                if (this.m_occ == null) break block7;
                this.m_occ.afterClose(this.m_privData);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.lifecycle = 4;
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.lifecycle = 4;
    }

    public synchronized void close(int n) throws SQLException {
        if ((n & 0x1000) != 0) {
            this.close();
            return;
        }
        if ((n & 1) != 0 && this.is_proxy) {
            this.closeProxySession();
            this.is_proxy = false;
        }
    }

    public synchronized void close(Properties properties) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public void closeInternal(boolean bl) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    synchronized void closeLogicalConnection() throws SQLException {
        this.close_statements(false);
        if (this.m_clientIdSet) {
            this.clearClientIdentifier(this.m_clientId);
        }
        this.logicalConnectionAttached = null;
    }

    void closeProxySession() throws SQLException {
    }

    synchronized void close_statements(boolean bl) throws SQLException {
        OracleStatement oracleStatement;
        if (bl && this.isStatementCacheInitialized()) {
            this.statementCache.close();
            this.statementCache = null;
            this.m_stmtClearMetaData = true;
        }
        OracleStatement oracleStatement2 = this.statements;
        while (oracleStatement2 != null) {
            oracleStatement = oracleStatement2.nextChild;
            if (oracleStatement2.serverCursor) {
                oracleStatement2.close();
                this.remove_statement(oracleStatement2);
            }
            oracleStatement2 = oracleStatement;
        }
        oracleStatement2 = this.statements;
        while (oracleStatement2 != null) {
            oracleStatement = oracleStatement2.next;
            oracleStatement2.close();
            this.remove_statement(oracleStatement2);
            oracleStatement2 = oracleStatement;
        }
    }

    public synchronized void commit() throws SQLException {
        this.disallowGlobalTxnMode(114);
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleStatement oracleStatement = this.statements;
        while (oracleStatement != null) {
            if (!oracleStatement.closed) {
                oracleStatement.sendBatch();
            }
            oracleStatement = oracleStatement.next;
        }
        this.needLine();
        this.do_commit();
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        return new BFILE(this, byArray);
    }

    public BfileDBAccess createBfileDBAccess() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        return new BLOB(this, byArray);
    }

    public BlobDBAccess createBlobDBAccess() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        return new CLOB(this, byArray);
    }

    public CLOB createClob(byte[] byArray, short s) throws SQLException {
        return new CLOB(this, byArray, s);
    }

    public ClobDBAccess createClobDBAccess() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(-1, -1);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleStatement oracleStatement = null;
        oracleStatement = this.driverExtension.allocateStatement(this, n, n2);
        return oracleStatement;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return null;
    }

    void disallowGlobalTxnMode(int n) throws SQLException {
        if (this.m_txn_mode == 1) {
            DatabaseError.throwSqlException(n);
        }
    }

    abstract void doAbort() throws SQLException;

    void doProxySession(int n, Properties properties) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    abstract void do_cancel() throws SQLException;

    abstract void do_commit() throws SQLException;

    abstract String do_getDatabaseProductVersion() throws SQLException;

    abstract short do_getVersionNumber() throws SQLException;

    abstract void do_rollback() throws SQLException;

    abstract void do_setAutoCommit(boolean var1) throws SQLException;

    void ensureClassMapExists() {
        if (this.map == null) {
            this.initializeClassMap();
        }
    }

    public boolean getAutoClose() throws SQLException {
        return true;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.auto_commit;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.big_endian == null) {
            int[] nArray = Util.toJavaUnsignedBytes(this.getFDO(true));
            int n = nArray[6 + nArray[5] + nArray[6] + 5];
            int n2 = n & 0x10;
            if (n2 < 0) {
                n2 += 256;
            }
            this.big_endian = n2 > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.big_endian;
    }

    public int getC2SNlsRatio() {
        return 1;
    }

    public synchronized CallableStatement getCallWithKey(String string) throws SQLException {
        if (this.statementCache != null) {
            OracleStatement oracleStatement = this.statementCache.searchExplicitCache(string);
            if (oracleStatement == null || oracleStatement.statementType == 2) {
                return (CallableStatement)((Object)oracleStatement);
            }
            DatabaseError.throwSqlException(125);
            return null;
        }
        return null;
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public synchronized Object getClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(object);
    }

    public synchronized Properties getConnectionAttributes() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public int getConnectionCacheCallbackFlag() throws SQLException {
        DatabaseError.throwSqlException(152);
        return 0;
    }

    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public int getConnectionReleasePriority() throws SQLException {
        DatabaseError.throwSqlException(152);
        return 0;
    }

    public boolean getCreateStatementAsRefCursor() {
        return false;
    }

    public Properties getDBAccessProperties() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.databaseProductVersion == uninitializedMarker) {
            this.needLine();
            this.databaseProductVersion = this.do_getDatabaseProductVersion();
        }
        return this.databaseProductVersion;
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DatabaseError.throwSqlException(65);
        }
        return this.conversion.getDbCharSet();
    }

    public Calendar getDbTzCalendar() {
        return this.m_dbTzCalendar;
    }

    public boolean getDefaultAutoRefetch() throws SQLException {
        return this.m_defaultAutoRefetch;
    }

    public synchronized int getDefaultExecuteBatch() {
        return this.default_batch;
    }

    public boolean getDefaultFixedString() {
        return this.defaultFixedString;
    }

    public int getDefaultRowPrefetch() {
        return this.default_row_prefetch;
    }

    int getDefaultStreamChunkSize() {
        return this.m_streamChunkSize;
    }

    public synchronized Object getDescriptor(String string) {
        Object var2_2 = null;
        if (string != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(string);
        }
        return var2_2;
    }

    public synchronized Object getDescriptor(byte[] byArray) {
        Object var2_2 = null;
        if (byArray != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(new ByteArrayKey(byArray));
        }
        return var2_2;
    }

    public short getDriverCharSet() {
        return this.conversion.getDriverCharSet();
    }

    public short getEndToEndECIDSequenceNumber() throws SQLException {
        return this.endToEndECIDSequenceNumber;
    }

    public synchronized String[] getEndToEndMetrics() throws SQLException {
        String[] stringArray;
        if (this.endToEndValues == null) {
            stringArray = null;
        } else {
            stringArray = new String[this.endToEndValues.length];
            System.arraycopy(this.endToEndValues, 0, stringArray, 0, this.endToEndValues.length);
        }
        return stringArray;
    }

    public synchronized boolean getExplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getExplicitCachingEnabled();
    }

    public synchronized byte[] getFDO(boolean bl) throws SQLException {
        if (this.fdo == null && bl) {
            CallableStatement callableStatement = null;
            try {
                callableStatement = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(2, -4);
                callableStatement.execute();
                this.fdo = callableStatement.getBytes(2);
            }
            finally {
                Object var4_3 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
            }
        }
        return this.fdo;
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n) throws SQLException {
    }

    public int getHeapAllocSize() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public int getHeartbeatNoChangeCount() throws SQLException {
        DatabaseError.throwSqlException(152);
        return -1;
    }

    public int getHoldability() throws SQLException {
        return 0;
    }

    public synchronized boolean getImplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getImplicitCachingEnabled();
    }

    public boolean getIncludeSynonyms() {
        return this.include_synonyms;
    }

    public boolean getJ2EE13Compliant() {
        return this.m_j2ee13Compliant;
    }

    public synchronized Object getJavaObject(String string) throws SQLException {
        Object var2_2 = null;
        try {
            if (string != null && this.map != null) {
                Class clazz = (Class)this.map.get(string);
                var2_2 = clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public synchronized Map getJavaObjectTypeMap() {
        return this.m_javaObjectMap;
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DatabaseError.throwSqlException(65);
        }
        return this.conversion.getDriverCharSet();
    }

    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        LogicalConnection logicalConnection;
        if (this.logicalConnectionAttached != null || oraclePooledConnection.getPhysicalHandle() != this) {
            DatabaseError.throwSqlException(143);
        }
        this.logicalConnectionAttached = logicalConnection = new LogicalConnection(oraclePooledConnection, this, bl);
        return logicalConnection;
    }

    public int getMaxCharSize() throws SQLException {
        DatabaseError.throwSqlException(58);
        return -1;
    }

    public int getMaxCharbyteSize() {
        return this.conversion.getMaxCharbyteSize();
    }

    public int getMaxNCharbyteSize() {
        return this.conversion.getMaxNCharbyteSize();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OracleDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    public short getNCharSet() {
        return this.conversion.getNCharSet();
    }

    public short getNCsId() throws SQLException {
        if (this.conversion == null) {
            DatabaseError.throwSqlException(65);
        }
        return this.conversion.getNCharSet();
    }

    public int getNlsRatio() {
        return 1;
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public Properties getOCIHandles() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
    }

    public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this;
    }

    public Properties getProperties() {
        return this.connectionProperties;
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        Hashtable<String, Map> hashtable = new Hashtable<String, Map>();
        hashtable.put("obj_type_map", this.m_javaObjectMap);
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", this.user);
        ((Hashtable)properties).put("password", this.password);
        ((Hashtable)properties).put("connection_url", this.url);
        ((Hashtable)properties).put("connect_auto_commit", String.valueOf(this.auto_commit));
        ((Hashtable)properties).put("trans_isolation", String.valueOf(this.trans_level));
        if (this.getStatementCacheSize() != -1) {
            ((Hashtable)properties).put("stmt_cache_size", String.valueOf(this.getStatementCacheSize()));
            ((Hashtable)properties).put("implicit_cache_enabled", String.valueOf(this.getImplicitCachingEnabled()));
            ((Hashtable)properties).put("explict_cache_enabled", String.valueOf(this.getExplicitCachingEnabled()));
        }
        ((Hashtable)properties).put("defaultExecuteBatch", String.valueOf(this.default_batch));
        ((Hashtable)properties).put("prefetch", String.valueOf(this.default_row_prefetch));
        ((Hashtable)properties).put("remarks", String.valueOf(this.report_remarks));
        ((Hashtable)properties).put("AccumulateBatchResult", String.valueOf(this.m_accumulateBatchResult));
        ((Hashtable)properties).put("oracle.jdbc.J2EE13Compliant", String.valueOf(this.m_j2ee13Compliant));
        ((Hashtable)properties).put("processEscapes", String.valueOf(this.m_process_escapes));
        ((Hashtable)properties).put("restrictGetTables", String.valueOf(this.restrict_getTables));
        ((Hashtable)properties).put("synonyms", String.valueOf(this.include_synonyms));
        ((Hashtable)properties).put("fixedString", String.valueOf(this.defaultFixedString));
        hashtable.put("connection_properties", properties);
        oraclePooledConnection.setProperties(hashtable);
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public synchronized boolean getRemarksReporting() {
        return this.report_remarks;
    }

    public synchronized boolean getReportRemarks() {
        return this.report_remarks;
    }

    public boolean getRestrictGetTables() {
        return this.restrict_getTables;
    }

    public synchronized String getSQLType(Object object) throws SQLException {
        if (object != null && this.map != null) {
            String string = object.getClass().getName();
            return (String)this.map.get(string);
        }
        return null;
    }

    public String getSessionTimeZone() {
        return this.m_sessionTimeZone;
    }

    public synchronized long getStartTime() throws SQLException {
        DatabaseError.throwSqlException(152);
        return -1L;
    }

    public synchronized int getStatementCacheSize() throws SQLException {
        if (this.statementCache == null) {
            return -1;
        }
        return this.statementCache.getCacheSize();
    }

    public synchronized PreparedStatement getStatementWithKey(String string) throws SQLException {
        if (this.statementCache != null) {
            OracleStatement oracleStatement = this.statementCache.searchExplicitCache(string);
            if (oracleStatement == null || oracleStatement.statementType == 1) {
                return (PreparedStatement)((Object)oracleStatement);
            }
            DatabaseError.throwSqlException(125);
            return null;
        }
        return null;
    }

    public synchronized int getStmtCacheSize() {
        int n = 0;
        try {
            n = this.getStatementCacheSize();
        }
        catch (SQLException sQLException) {}
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public short getStructAttrNCsId() throws SQLException {
        return this.getNCsId();
    }

    OracleTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = OracleTimeout.newTimeout(this.url);
        }
        return this.timeout;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.trans_level;
    }

    public int getTxnMode() {
        return this.m_txn_mode;
    }

    public synchronized Map getTypeMap() {
        this.ensureClassMapExists();
        return this.map;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public synchronized boolean getUsingXAFlag() {
        return this.UsingXA;
    }

    public short getVersionNumber() throws SQLException {
        if (this.versionNumber == -1) {
            PhysicalConnection physicalConnection = this;
            synchronized (physicalConnection) {
                if (this.versionNumber == -1) {
                    this.needLine();
                    this.versionNumber = this.do_getVersionNumber();
                }
            }
        }
        return this.versionNumber;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        return this;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.XA_wants_error;
    }

    public XAResource getXAResource() throws SQLException {
        DatabaseError.throwSqlException(164);
        return null;
    }

    synchronized void holdLine(OracleStatement oracleStatement) {
        this.statement_holding_line = oracleStatement;
    }

    synchronized void holdLine(oracle.jdbc.internal.OracleStatement oracleStatement) {
        this.holdLine((OracleStatement)oracleStatement);
    }

    void initUserName() throws SQLException {
        ResultSet resultSet;
        Statement statement;
        block7: {
            if (this.user != null) {
                return;
            }
            statement = null;
            resultSet = null;
            try {
                statement = this.createStatement();
                ((OracleStatement)statement).setRowPrefetch(1);
                resultSet = statement.executeQuery("SELECT USER FROM DUAL");
                if (!resultSet.next()) break block7;
                this.user = resultSet.getString(1);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                resultSet = null;
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        resultSet = null;
    }

    void initialize(String string, String string2, String string3, Hashtable hashtable, Map map, Map map2, String string4) throws SQLException {
        this.m_stmtClearMetaData = false;
        this.database = string4;
        this.url = string;
        if (string2 != null) {
            this.user = string2.toUpperCase();
        }
        this.protocol = string3;
        this.default_row_prefetch = OracleConnection.DEFAULT_ROW_PREFETCH;
        this.default_batch = 1;
        this.descriptorCache = hashtable != null ? hashtable : new Hashtable(10);
        this.map = map;
        this.m_javaObjectMap = map2 != null ? map2 : new Hashtable(10);
        this.lifecycle = 1;
        this.trans_level = 2;
        this.XA_wants_error = false;
        this.UsingXA = false;
        this.m_clientIdSet = false;
    }

    void initializeClassMap() {
        Hashtable hashtable = new Hashtable(10);
        this.addDefaultClassMapEntriesTo(hashtable);
        this.map = hashtable;
    }

    void initializeSetCHARCharSetObjs() {
        this.setCHARNCharSetObj = this.conversion.getDriverNCharSetObj();
        this.setCHARCharSetObj = this.conversion.getDriverCharSetObj();
    }

    void internalClose() throws SQLException {
        this.lifecycle = 4;
    }

    public boolean isAccumulateBatchResult() {
        return this.m_accumulateBatchResult;
    }

    public boolean isCharSetMultibyte(short s) {
        return DBConversion.isCharSetMultibyte(s);
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.lifecycle != 1;
    }

    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        PhysicalConnection physicalConnection = this;
        PhysicalConnection physicalConnection2 = (PhysicalConnection)oracleConnection.getPhysicalConnection();
        return physicalConnection == physicalConnection2 || physicalConnection.url.equals(physicalConnection2.url) || physicalConnection2.protocol != null && physicalConnection2.protocol.equals("kprb");
    }

    public synchronized boolean isLogicalConnection() {
        return false;
    }

    public synchronized boolean isProxySession() {
        return this.is_proxy;
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_readOnly;
    }

    public synchronized boolean isStatementCacheInitialized() {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getCacheSize() != 0;
    }

    public boolean isV8Compatible() throws SQLException {
        return this.m_v8Compatible;
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.conversion.javaCharsToCHARBytes(cArray, n, byArray);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.conversion.javaCharsToNCHARBytes(cArray, n, byArray);
    }

    void logoff() throws SQLException {
    }

    abstract void logon() throws SQLException;

    public String nativeSQL(String string) throws SQLException {
        if (this.m_osql == null) {
            this.m_osql = new OracleSql(this.conversion);
            this.m_osql.isV8Compatible = this.m_v8Compatible;
        }
        this.m_osql.initialize(string);
        String string2 = this.m_osql.getSql(this.m_process_escapes);
        return string2;
    }

    synchronized void needLine() throws SQLException {
        if (this.statement_holding_line != null) {
            this.statement_holding_line.freeLine();
        }
    }

    public ResultSet newArrayDataResultSet(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        return new ArrayDataResultSet((OracleConnection)this, aRRAY, l, n, map);
    }

    public ResultSet newArrayDataResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        return new ArrayDataResultSet((OracleConnection)this, datumArray, l, n, map);
    }

    public ResultSet newArrayLocatorResultSet(ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Map map) throws SQLException {
        return new ArrayLocatorResultSet(this, arrayDescriptor, byArray, l, n, map);
    }

    public ResultSetMetaData newStructMetaData(StructDescriptor structDescriptor) throws SQLException {
        return new StructMetaData(structDescriptor);
    }

    int numberOfDescriptorCacheEntries() {
        if (this.descriptorCache != null) {
            return this.descriptorCache.size();
        }
        return 0;
    }

    abstract void open(OracleStatement var1) throws SQLException;

    public synchronized void openProxySession(int n, Properties properties) throws SQLException {
        if (this.is_proxy) {
            DatabaseError.throwSqlException(149);
        }
        String string = properties.getProperty("PROXY_USER_NAME");
        String string2 = properties.getProperty("PROXY_USER_PASSWORD");
        String string3 = properties.getProperty("PROXY_DISTINGUISHED_NAME");
        Object v = ((Hashtable)properties).get("PROXY_CERTIFICATE");
        if (n == 1) {
            if (string == null && string2 == null) {
                DatabaseError.throwSqlException(150);
            }
        } else if (n == 2) {
            if (string3 == null) {
                DatabaseError.throwSqlException(150);
            }
        } else if (n == 3) {
            if (v == null) {
                DatabaseError.throwSqlException(150);
            }
            try {
                byte[] byArray = (byte[])v;
            }
            catch (ClassCastException classCastException) {
                DatabaseError.throwSqlException(150);
            }
        } else {
            DatabaseError.throwSqlException(150);
        }
        this.doProxySession(n, properties);
    }

    public synchronized void oracleReleaseSavepoint(OracleSavepoint oracleSavepoint) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public synchronized void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        this.disallowGlobalTxnMode(115);
        if (this.auto_commit) {
            DatabaseError.throwSqlException(121);
        }
        if (this.m_svptStmt == null || ((OracleStatement)this.m_svptStmt).closed) {
            this.m_svptStmt = this.createStatement();
        }
        String string = null;
        try {
            string = oracleSavepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            string = "ORACLE_SVPT_" + oracleSavepoint.getSavepointId();
        }
        this.m_svptStmt.executeUpdate("ROLLBACK TO " + string);
    }

    public synchronized OracleSavepoint oracleSetSavepoint() throws SQLException {
        this.disallowGlobalTxnMode(117);
        if (this.auto_commit) {
            DatabaseError.throwSqlException(120);
        }
        if (this.m_svptStmt == null || ((OracleStatement)this.m_svptStmt).closed) {
            this.m_svptStmt = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint = new oracle.jdbc.driver.OracleSavepoint();
        String string = "SAVEPOINT ORACLE_SVPT_" + oracleSavepoint.getSavepointId();
        this.m_svptStmt.executeUpdate(string);
        return oracleSavepoint;
    }

    public synchronized OracleSavepoint oracleSetSavepoint(String string) throws SQLException {
        this.disallowGlobalTxnMode(117);
        if (this.auto_commit) {
            DatabaseError.throwSqlException(120);
        }
        if (this.m_svptStmt == null || ((OracleStatement)this.m_svptStmt).closed) {
            this.m_svptStmt = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint = new oracle.jdbc.driver.OracleSavepoint(string);
        String string2 = "SAVEPOINT " + oracleSavepoint.getSavepointName();
        this.m_svptStmt.executeUpdate(string2);
        return oracleSavepoint;
    }

    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int pingDatabase(int n) throws SQLException {
        if (this.lifecycle != 1) {
            return -1;
        }
        Statement statement = null;
        try {
            try {
                statement = this.createStatement();
                ((OracleStatement)statement).defineColumnType(1, 12, 1);
                statement.executeQuery("SELECT 'x' FROM DUAL");
            }
            catch (SQLException sQLException) {
                int n2 = -1;
                Object var5_4 = null;
                if (statement == null) return n2;
                statement.close();
                return n2;
            }
            Object var5_5 = null;
            if (statement == null) return 0;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return 0;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, -1, -1);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (string == null || string == uninitializedMarker) {
            DatabaseError.throwSqlException(104);
        }
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleCallableStatement oracleCallableStatement = null;
        if (this.statementCache != null) {
            oracleCallableStatement = (OracleCallableStatement)this.statementCache.searchImplicitCache(string, 2, n != -1 || n2 != -1 ? ResultSetUtil.getRsetTypeCode(n, n2) : 1);
        }
        if (oracleCallableStatement == null) {
            oracleCallableStatement = this.driverExtension.allocateCallableStatement(this, string, n, n2);
        }
        return oracleCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return null;
    }

    public synchronized CallableStatement prepareCallWithKey(String string) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (string == null) {
            return null;
        }
        if (!this.isStatementCacheInitialized()) {
            DatabaseError.throwSqlException(95);
        }
        OracleCallableStatement oracleCallableStatement = null;
        oracleCallableStatement = (OracleCallableStatement)this.statementCache.searchExplicitCache(string);
        return oracleCallableStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, -1, -1);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (string == null || string == uninitializedMarker) {
            DatabaseError.throwSqlException(104);
        }
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        if (this.statementCache != null) {
            oraclePreparedStatement = (OraclePreparedStatement)this.statementCache.searchImplicitCache(string, 1, n != -1 || n2 != -1 ? ResultSetUtil.getRsetTypeCode(n, n2) : 1);
        }
        if (oraclePreparedStatement == null) {
            oraclePreparedStatement = this.driverExtension.allocatePreparedStatement(this, string, n, n2);
        }
        return oraclePreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized PreparedStatement prepareStatementWithKey(String string) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (string == null) {
            return null;
        }
        if (!this.isStatementCacheInitialized()) {
            DatabaseError.throwSqlException(95);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.statementCache.searchExplicitCache(string);
        return oraclePreparedStatement;
    }

    public void printState() {
        try {
            short s = this.getJdbcCsId();
            short s2 = this.getDbCsId();
            short s3 = this.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public synchronized void purgeExplicitCache() throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.purgeExplicitCache();
        }
    }

    public synchronized void purgeImplicitCache() throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.purgeImplicitCache();
        }
    }

    public synchronized void putDescriptor(String string, Object object) throws SQLException {
        if (string != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(string, object);
        } else {
            DatabaseError.throwSqlException(68);
        }
    }

    public synchronized void putDescriptor(byte[] byArray, Object object) throws SQLException {
        if (byArray != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(new ByteArrayKey(byArray), object);
        } else {
            DatabaseError.throwSqlException(68);
        }
    }

    public oracle.jdbc.internal.OracleStatement refCursorCursorToStatement(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.m_occ = oracleCloseCallback;
        this.m_privData = object;
    }

    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback oracleConnectionCacheCallback, Object object, int n) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    void registerHeartbeat() throws SQLException {
        if (this.logicalConnectionAttached != null) {
            this.logicalConnectionAttached.registerHeartbeat();
        }
    }

    public synchronized void registerSQLType(String string, Class clazz) throws SQLException {
        if (string == null || clazz == null) {
            DatabaseError.throwSqlException(68);
        }
        this.ensureClassMapExists();
        this.map.put(string, clazz);
        this.map.put(clazz.getName(), string);
    }

    public synchronized void registerSQLType(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DatabaseError.throwSqlException(68);
        }
        try {
            this.registerSQLType(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            DatabaseError.throwSqlException(1, "Class not found: " + string2);
        }
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    synchronized void releaseLine() {
        this.releaseLineForCancel();
    }

    void releaseLineForCancel() {
        this.statement_holding_line = null;
    }

    public synchronized void removeAllDescriptor() {
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public synchronized Object removeClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(object);
    }

    public synchronized void removeDecriptor(String string) {
        this.removeDescriptor(string);
    }

    public synchronized void removeDecriptor(byte[] byArray) {
        if (byArray != null && this.descriptorCache != null) {
            this.descriptorCache.remove(new ByteArrayKey(byArray));
        }
    }

    public synchronized void removeDescriptor(String string) {
        if (string != null && this.descriptorCache != null) {
            this.descriptorCache.remove(string);
        }
    }

    synchronized void remove_statement(OracleStatement oracleStatement) {
        OracleStatement oracleStatement2 = oracleStatement.prev;
        OracleStatement oracleStatement3 = oracleStatement.next;
        if (oracleStatement2 == null) {
            if (this.statements != oracleStatement) {
                return;
            }
            this.statements = oracleStatement3;
        } else {
            oracleStatement2.next = oracleStatement3;
        }
        if (oracleStatement3 != null) {
            oracleStatement3.prev = oracleStatement2;
        }
        oracleStatement.next = null;
        oracleStatement.prev = null;
    }

    public synchronized void rollback() throws SQLException {
        this.disallowGlobalTxnMode(115);
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        this.needLine();
        this.do_rollback();
    }

    public Class safelyGetClassForName(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public synchronized void setAbandonedTimeoutEnabled(boolean bl) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public void setAccumulateBatchResult(boolean bl) {
        this.m_accumulateBatchResult = bl;
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        if (!bl) {
            DatabaseError.throwSqlException(31);
        }
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (bl) {
            this.disallowGlobalTxnMode(116);
        }
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        this.needLine();
        this.do_setAutoCommit(bl);
        this.auto_commit = bl;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(object, object2);
    }

    public void setClientIdentifier(String string) throws SQLException {
        if (!this.useDMSForEndToEnd) {
            String[] stringArray = this.getEndToEndMetrics();
            if (stringArray == null) {
                stringArray = new String[4];
            }
            stringArray[1] = string;
            this.setEndToEndMetrics(stringArray, this.getEndToEndECIDSequenceNumber());
        }
    }

    public synchronized void setConnectionReleasePriority(int n) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public void setCreateStatementAsRefCursor(boolean bl) {
    }

    void setDbTzCalendar(String string) {
        char c = string.charAt(0);
        string = c == '-' || c == '+' ? "GMT" + string : "GMT+" + string;
        TimeZone timeZone = TimeZone.getTimeZone(string);
        this.m_dbTzCalendar = new GregorianCalendar(timeZone);
    }

    public void setDefaultAutoRefetch(boolean bl) throws SQLException {
        this.m_defaultAutoRefetch = bl;
    }

    public synchronized void setDefaultExecuteBatch(int n) throws SQLException {
        if (n <= 0) {
            DatabaseError.throwSqlException(42);
        }
        this.default_batch = n;
    }

    public void setDefaultFixedString(boolean bl) {
        this.defaultFixedString = bl;
    }

    public void setDefaultNChar(boolean bl) {
        this.defaultNChar = bl;
    }

    public void setDefaultRowPrefetch(int n) throws SQLException {
        if (n <= 0) {
            DatabaseError.throwSqlException(20);
        }
        this.default_row_prefetch = n;
    }

    public synchronized void setEndToEndMetrics(String[] stringArray, short s) throws SQLException {
        if (!this.useDMSForEndToEnd) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            this.setEndToEndMetricsInternal(stringArray2, s);
        }
    }

    void setEndToEndMetricsInternal(String[] stringArray, short s) throws SQLException {
        if (stringArray != this.endToEndValues) {
            if (stringArray.length != 4) {
                DatabaseError.throwSqlException(156);
            }
            int n = 0;
            while (n < 4) {
                String string = stringArray[n];
                if (string != null && string.length() > endToEndMaxLength[n]) {
                    DatabaseError.throwSqlException(159, string);
                }
                ++n;
            }
            if (this.endToEndValues != null) {
                int n2 = 0;
                while (n2 < 4) {
                    String string = stringArray[n2];
                    if (string == null && this.endToEndValues[n2] != null || string != null && !string.equals(this.endToEndValues[n2])) {
                        this.endToEndHasChanged[n2] = true;
                        this.endToEndAnyChanged = true;
                    }
                    ++n2;
                }
                this.endToEndHasChanged[0] = this.endToEndHasChanged[0] | this.endToEndHasChanged[3];
            } else {
                int n3 = 0;
                while (n3 < 4) {
                    this.endToEndHasChanged[n3] = true;
                    ++n3;
                }
                this.endToEndAnyChanged = true;
            }
            this.endToEndValues = stringArray;
        }
        this.endToEndECIDSequenceNumber = s;
    }

    public synchronized void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setExplicitCachingEnabled(bl);
    }

    public synchronized void setFDO(byte[] byArray) throws SQLException {
        this.fdo = byArray;
    }

    public void setHoldability(int n) throws SQLException {
    }

    public synchronized void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setImplicitCachingEnabled(bl);
    }

    public void setIncludeSynonyms(boolean bl) {
        this.include_synonyms = bl;
    }

    public void setJ2EE13Compliant(boolean bl) {
        this.m_j2ee13Compliant = bl;
    }

    public synchronized void setJavaObjectTypeMap(Map map) {
        this.m_javaObjectMap = map;
    }

    public void setPlsqlWarnings(String string) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(68);
        }
        string = string.trim().toUpperCase();
        String string2 = "ALTER SESSION SET PLSQL_WARNINGS=" + string;
        String string3 = "ALTER SESSION SET EVENTS='10933 TRACE NAME CONTEXT LEVEL 32768'";
        Statement statement = this.createStatement(-1, -1);
        statement.execute(string2);
        if (string.equals("'DISABLE:ALL'")) {
            this.plsqlCompilerWarnings = false;
        } else {
            statement.execute(string3);
            this.plsqlCompilerWarnings = true;
        }
        statement.close();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.m_readOnly = bl;
    }

    public synchronized void setRemarksReporting(boolean bl) {
        this.report_remarks = bl;
    }

    public void setRestrictGetTables(boolean bl) {
        this.restrict_getTables = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSessionTimeZone(String string) throws SQLException {
        block5: {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.createStatement();
                statement.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + string + "'");
                resultSet = statement.executeQuery("SELECT DBTIMEZONE FROM DUAL");
                resultSet.next();
                String string2 = resultSet.getString(1);
                this.setDbTzCalendar(string2);
                Object var5_6 = null;
                if (statement == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            statement.close();
        }
        this.m_sessionTimeZone = string;
    }

    public synchronized void setStartTime(long l) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public synchronized void setStatementCacheSize(int n) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(n);
        } else {
            this.statementCache.resize(n);
        }
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStatementCacheSize(n);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        this.setStatementCacheSize(n);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
        this.m_stmtClearMetaData = bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setTransactionIsolation(int var1_1) throws SQLException {
        var2_2 = (OracleStatement)this.createStatement();
        try {
            switch (var1_1) {
                case 2: {
                    var2_2.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.trans_level = 2;
                    ** break;
                }
                case 8: {
                    var2_2.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.trans_level = 8;
                    ** break;
                }
            }
            DatabaseError.throwSqlException(30);
        }
        catch (Throwable var3_5) {
            var4_4 = null;
            var2_2.close();
            throw var3_5;
        }
lbl21:
        // 3 sources

        var4_3 = null;
        var2_2.close();
    }

    public void setTxnMode(int n) {
        this.m_txn_mode = n;
    }

    public synchronized void setTypeMap(Map map) {
        this.addDefaultClassMapEntriesTo(map);
        this.map = map;
    }

    public synchronized void setUsingXAFlag(boolean bl) {
        this.UsingXA = bl;
    }

    public void setWarnings(SQLWarning sQLWarning) {
        this.m_warning = sQLWarning;
    }

    public void setWrapper(oracle.jdbc.OracleConnection oracleConnection) {
        this.wrapper = oracleConnection;
    }

    public synchronized void setXAErrorFlag(boolean bl) {
        this.XA_wants_error = bl;
    }

    public synchronized void shutdown(int n) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
    }

    public synchronized void startup(String string, int n) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
    }

    public Datum toDatum(CustomDatum customDatum) throws SQLException {
        return customDatum.toDatum(this);
    }

    public void trace(String string) {
    }

    public oracle.jdbc.OracleConnection unwrap() {
        return null;
    }

    public static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection oracleConnection) {
        oracle.jdbc.OracleConnection oracleConnection2;
        oracle.jdbc.OracleConnection oracleConnection3 = oracleConnection2 = oracleConnection;
        while (oracleConnection3 != null) {
            oracleConnection2 = oracleConnection3;
            oracleConnection3 = oracleConnection2.unwrap();
        }
        return (OracleConnection)oracleConnection2;
    }

    void updateEndToEndMetrics() throws SQLException {
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return false;
    }
}

