/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CIntervalymAccessor
extends IntervalymAccessor {
    T4CMAREngine mare;
    static int max_length = 11;
    final int[] meta = new int[1];
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    T4CIntervalymAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, max_length, s, n2, bl);
        this.mare = t4CMAREngine;
    }

    T4CIntervalymAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, int n7, int n8, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, max_length, bl, n2, n3, n4, n5, n6, s);
        this.mare = t4CMAREngine;
        this.definedColumnType = n7;
        this.definedColumnSize = n8;
    }

    void copyRow() throws SQLException, IOException {
        int n = this.lastRowProcessed == 0 ? this.stmt.row_prefetch : this.lastRowProcessed;
        int n2 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n3 = this.columnIndex + (n - 1) * this.byteLength;
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.indicatorIndex + n - 1;
        int n6 = this.lengthIndex + this.lastRowProcessed;
        int n7 = this.lengthIndex + n - 1;
        short s = this.rowSpaceIndicator[n7];
        this.rowSpaceIndicator[n6] = s;
        this.rowSpaceIndicator[n4] = this.rowSpaceIndicator[n5];
        System.arraycopy(this.rowSpaceByte, n3, this.rowSpaceByte, n2, s);
        ++this.lastRowProcessed;
    }

    Object getObject(int n) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n);
                }
                case -103: {
                    return this.getINTERVALYM(n);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(n);
                }
            }
            DatabaseError.throwSqlException(4);
            return null;
        }
        return var2_2;
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.stmt.sql_kind != 1 && this.stmt.sql_kind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.stmt.sql_kind == 1 || this.stmt.sql_kind == 4) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n, int n2) throws SQLException {
        int n3 = this.columnIndex + (n2 - 1) * this.byteLength;
        int n4 = this.columnIndexLastRow + (n - 1) * this.byteLength;
        int n5 = this.indicatorIndex + n2 - 1;
        int n6 = this.indicatorIndexLastRow + n - 1;
        int n7 = this.lengthIndex + n2 - 1;
        int n8 = this.lengthIndexLastRow + n - 1;
        short s = sArray[n8];
        this.rowSpaceIndicator[n7] = s;
        this.rowSpaceIndicator[n5] = sArray[n6];
        if (s != 0) {
            System.arraycopy(byArray, n4, this.rowSpaceByte, n3, s);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.indicatorIndex + this.lastRowProcessed;
        int n2 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
            ++this.lastRowProcessed;
            if (this.mare.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        this.mare.unmarshalCLR(this.rowSpaceByte, n3, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
        } else {
            this.rowSpaceIndicator[n2] = (short)this.meta[0];
            this.rowSpaceIndicator[n] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }
}

