/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRefTypeAccessor
extends RefTypeAccessor {
    static final int max_length = 4000;
    T4CMAREngine mare;
    final int[] meta = new int[1];
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    T4CRefTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string, int n7, int n8, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, bl, n2, n3, n4, n5, n6, s, string);
        this.mare = t4CMAREngine;
        this.definedColumnType = n7;
        this.definedColumnSize = n8;
        this.byteLength = 4000;
    }

    T4CRefTypeAccessor(OracleStatement oracleStatement, String string, short s, int n, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, string, s, n, bl);
        this.mare = t4CMAREngine;
        this.byteLength = 4000;
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.stmt.sql_kind != 1 && this.stmt.sql_kind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.stmt.sql_kind == 1 || this.stmt.sql_kind == 4) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.columnIndex + this.lastRowProcessed * this.byteLength;
        byte[] byArray = this.mare.unmarshalCLRforREFS();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.pickledBytes[this.lastRowProcessed] = byArray;
        this.meta[0] = byArray.length;
        this.processIndicator(this.meta[0]);
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
        } else {
            this.rowSpaceIndicator[n3] = (short)this.meta[0];
            this.rowSpaceIndicator[n2] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }
}

