/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRowidAccessor
extends RowidAccessor {
    T4CMAREngine mare;
    static final int max_length = 128;
    final int[] meta = new int[1];
    static final int KGRD_EXTENDED_OBJECT = 6;
    static final int KGRD_EXTENDED_BLOCK = 6;
    static final int KGRD_EXTENDED_FILE = 3;
    static final int KGRD_EXTENDED_SLOT = 3;
    static final int kd4_ubridtype_physicall = 1;
    static final int kd4_ubridtype_logical = 2;
    static final int kd4_ubridtype_remote = 3;
    static final int kd4_ubridtype_exttab = 4;
    static final int kd4_ubridlen_typeind = 1;
    static final byte[] kgrd_indbyte_char = new byte[]{65, 42, 45, 40, 41};
    static final byte[] kgrd_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] kgrd_index_64;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    static {
        byte[] byArray = new byte[128];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -1;
        byArray[124] = -1;
        byArray[125] = -1;
        byArray[126] = -1;
        byArray[127] = -1;
        kgrd_index_64 = byArray;
        _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    }

    T4CRowidAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, s, n2, bl);
        this.mare = t4CMAREngine;
        this.d_type = 104;
    }

    T4CRowidAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, int n7, int n8, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, bl, n2, n3, n4, n5, n6, s);
        this.mare = t4CMAREngine;
        this.definedColumnType = n7;
        this.definedColumnSize = n8;
        this.d_type = 104;
    }

    void copyRow() throws SQLException, IOException {
        int n = this.lastRowProcessed == 0 ? this.stmt.row_prefetch : this.lastRowProcessed;
        int n2 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n3 = this.columnIndex + (n - 1) * this.byteLength;
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.indicatorIndex + n - 1;
        int n6 = this.lengthIndex + this.lastRowProcessed;
        int n7 = this.lengthIndex + n - 1;
        short s = this.rowSpaceIndicator[n7];
        this.rowSpaceIndicator[n6] = s;
        this.rowSpaceIndicator[n4] = this.rowSpaceIndicator[n5];
        System.arraycopy(this.rowSpaceByte, n3, this.rowSpaceByte, n2, s + 2);
        ++this.lastRowProcessed;
    }

    Object getObject(int n) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n);
                }
                case -8: {
                    return this.getROWID(n);
                }
            }
            DatabaseError.throwSqlException(4);
            return null;
        }
        return var2_2;
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            if (this.c_type != 208 || this.rowSpaceByte[n2] == 1) {
                string = new String(this.rowSpaceByte, n2 + 2, (int)s);
                long[] lArray = T4CRowidAccessor.stringToRowid(string.getBytes(), 0, string.length());
                string = new String(T4CRowidAccessor.rowidToString(lArray));
            } else {
                string = T4CRowidAccessor.kgrdub2c(this.rowSpaceByte, s, n2 + 2);
            }
        }
        return string;
    }

    static final int kgrd42b(byte[] byArray, long l, int n, int n2) {
        int n3 = n;
        long l2 = l;
        while (n > 0) {
            byArray[n2 + n - 1] = kgrd_basis_64[(int)l2 & 0x3F];
            l2 = l2 >>> 6 & 0x3FFFFFFL;
            --n;
        }
        return n3 + n2;
    }

    static final long kgrdb42(byte[] byArray, int n, int n2) throws SQLException {
        long l = 0L;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n2 + n3];
            if ((by = kgrd_index_64[by]) == -1) {
                throw new SQLException("Char data to rowid conversion failed.");
            }
            l <<= 6;
            l |= (long)by;
            ++n3;
        }
        return l;
    }

    static final byte[] kgrdr2rc(long[] lArray) {
        long l = lArray[1];
        long l2 = lArray[2];
        long l3 = lArray[3];
        int n = 18;
        byte[] byArray = new byte[n];
        int n2 = 0;
        n2 = T4CRowidAccessor.lmx42h(byArray, l2, 8, n2);
        byArray[n2++] = 46;
        n2 = T4CRowidAccessor.lmx42h(byArray, l3, 4, n2);
        byArray[n2++] = 46;
        n2 = T4CRowidAccessor.lmx42h(byArray, l, 4, n2);
        return byArray;
    }

    static final String kgrdub2c(byte[] byArray, int n, int n2) throws SQLException {
        byte by = byArray[n2];
        char[] cArray = new char[512];
        int n3 = 0;
        int n4 = n - 1;
        int n5 = 4 * (n / 3) + (n % 3 == 0 ? n % 3 + 1 : 0);
        int n6 = 1 + n5 - 1;
        if (n6 != 0) {
            cArray[0] = (char)kgrd_indbyte_char[by - 1];
            int n7 = n2 + 1;
            n3 = 1;
            byte by2 = 0;
            while (n4 > 0) {
                cArray[n3++] = (char)kgrd_basis_64[(byArray[n7] & 0xFF) >> 2];
                if (n4 == 1) {
                    cArray[n3++] = (char)kgrd_basis_64[(byArray[n7] & 3) << 4];
                    break;
                }
                by2 = (byte)(byArray[n7 + 1] & 0xFF);
                cArray[n3++] = (char)kgrd_basis_64[(byArray[n7] & 3) << 4 | (by2 & 0xF0) >> 4];
                if (n4 == 2) {
                    cArray[n3++] = (char)kgrd_basis_64[(by2 & 0xF) << 2];
                    break;
                }
                cArray[n3++] = (char)kgrd_basis_64[(by2 & 0xF) << 2 | (byArray[n7 += 2] & 0xC0) >> 6];
                cArray[n3] = (char)kgrd_basis_64[byArray[n7] & 0x3F];
                n4 -= 3;
                ++n7;
                ++n3;
            }
        }
        return new String(cArray, 0, n3);
    }

    static final int lmx42h(byte[] byArray, long l, int n, int n2) {
        String string = Long.toHexString(l);
        int n3 = n;
        int n4 = 0;
        do {
            if (n4 < string.length()) {
                byArray[n2 + n - 1] = (byte)string.charAt(string.length() - n4 - 1);
                ++n4;
                continue;
            }
            byArray[n2 + n - 1] = 48;
        } while (--n > 0);
        return n3 + n2;
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.stmt.sql_kind != 1 && this.stmt.sql_kind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.stmt.sql_kind == 1 || this.stmt.sql_kind == 4) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    static final long[] rcToRowid(byte[] byArray, int n, int n2) throws SQLException {
        long l;
        int n3 = 18;
        if (n2 != n3) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] lArray = new long[3];
        String string = new String(byArray, n, n2);
        long l2 = Long.parseLong(string.substring(0, 8), 16);
        long l3 = Long.parseLong(string.substring(9, 13), 16);
        lArray[0] = l = Long.parseLong(string.substring(14, 8), 16);
        lArray[1] = l2;
        lArray[2] = l3;
        return lArray;
    }

    static final byte[] rowidToString(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        int n = 18;
        byte[] byArray = new byte[n];
        int n2 = 0;
        n2 = T4CRowidAccessor.kgrd42b(byArray, l, 6, n2);
        n2 = T4CRowidAccessor.kgrd42b(byArray, l2, 3, n2);
        n2 = T4CRowidAccessor.kgrd42b(byArray, l3, 6, n2);
        n2 = T4CRowidAccessor.kgrd42b(byArray, l4, 3, n2);
        return byArray;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n, int n2) throws SQLException {
        int n3 = this.columnIndex + (n2 - 1) * this.byteLength;
        int n4 = this.columnIndexLastRow + (n - 1) * this.byteLength;
        int n5 = this.indicatorIndex + n2 - 1;
        int n6 = this.indicatorIndexLastRow + n - 1;
        int n7 = this.lengthIndex + n2 - 1;
        int n8 = this.lengthIndexLastRow + n - 1;
        short s = sArray[n8];
        this.rowSpaceIndicator[n7] = s;
        this.rowSpaceIndicator[n5] = sArray[n6];
        if (s != 0) {
            System.arraycopy(byArray, n4, this.rowSpaceByte, n3, s + 2);
        }
    }

    static final long[] stringToRowid(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = 18;
        if (n2 != n3) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] lArray = new long[4];
        try {
            lArray[0] = T4CRowidAccessor.kgrdb42(byArray, 6, n);
            lArray[1] = T4CRowidAccessor.kgrdb42(byArray, 3, n += 6);
            lArray[2] = T4CRowidAccessor.kgrdb42(byArray, 6, n += 3);
            lArray[3] = T4CRowidAccessor.kgrdb42(byArray, 3, n += 6);
            n += 3;
        }
        catch (Exception exception) {
            lArray[0] = 0L;
            lArray[1] = 0L;
            lArray[2] = 0L;
            lArray[3] = 0L;
        }
        return lArray;
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            short s = this.mare.unmarshalUB1();
            long l = 0L;
            int n = 0;
            short s2 = 0;
            long l2 = 0L;
            int n2 = 0;
            if (s > 0) {
                l = this.mare.unmarshalUB4();
                n = this.mare.unmarshalUB2();
                s2 = this.mare.unmarshalUB1();
                l2 = this.mare.unmarshalUB4();
                n2 = this.mare.unmarshalUB2();
            }
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n3] = 0;
            ++this.lastRowProcessed;
            if (this.mare.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n4 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        if (this.c_type != 208) {
            short s = this.mare.unmarshalUB1();
            long l = 0L;
            int n5 = 0;
            short s3 = 0;
            long l3 = 0L;
            int n6 = 0;
            if (s > 0) {
                l = this.mare.unmarshalUB4();
                n5 = this.mare.unmarshalUB2();
                s3 = this.mare.unmarshalUB1();
                l3 = this.mare.unmarshalUB4();
                n6 = this.mare.unmarshalUB2();
            }
            if (l == 0L && n5 == 0 && s3 == 0 && l3 == 0L && n6 == 0) {
                this.meta[0] = 0;
            } else {
                long[] lArray = new long[]{l, n5, l3, n6};
                byte[] byArray = T4CRowidAccessor.rowidToString(lArray);
                int n7 = 18;
                if (this.byteLength - 2 < 18) {
                    n7 = this.byteLength - 2;
                }
                System.arraycopy(byArray, 0, this.rowSpaceByte, n4 + 2, n7);
                this.meta[0] = n7;
            }
        } else {
            this.meta[0] = (int)this.mare.unmarshalUB4();
            if (this.meta[0] > 0) {
                this.mare.unmarshalCLR(this.rowSpaceByte, n4 + 2, this.meta);
            }
        }
        this.rowSpaceByte[n4] = (byte)((this.meta[0] & 0xFF00) >> 8);
        this.rowSpaceByte[n4 + 1] = (byte)(this.meta[0] & 0xFF);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n3] = 0;
        } else {
            this.rowSpaceIndicator[n3] = (short)this.meta[0];
            this.rowSpaceIndicator[n] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }
}

