/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class TimestampAccessor
extends DateTimeCommonAccessor {
    static final int max_length = 11;

    TimestampAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 180, 180, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 180, 180, s, false);
        this.initForDescribe(180, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    Object getObject(int n) throws SQLException {
        Serializable serializable = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            if (this.external_type == 0) {
                serializable = this.stmt.connection.m_j2ee13Compliant ? this.getTimestamp(n) : this.getTIMESTAMP(n);
            } else {
                switch (this.external_type) {
                    case 93: {
                        return this.getTimestamp(n);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return serializable;
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getTIMESTAMP(n);
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            int n4 = 0;
            if (s == 11) {
                n4 = this.oracleNanos(n2);
            }
            string = String.valueOf(n3) + "-" + this.rowSpaceByte[2 + n2] + "-" + this.rowSpaceByte[3 + n2] + "." + (this.rowSpaceByte[4 + n2] - 1) + "." + (this.rowSpaceByte[5 + n2] - 1) + ". " + (this.rowSpaceByte[6 + n2] - 1) + ". " + n4;
        }
        return string;
    }

    TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            tIMESTAMP = new TIMESTAMP(byArray);
        }
        return tIMESTAMP;
    }

    Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            TimeZone timeZone = this.stmt.getDefaultTimeZone();
            int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            if (n3 <= 0) {
                ++n3;
            }
            timestamp = new Timestamp(DateTimeCommonAccessor.getMillis(n3, this.oracleMonth(n2), this.oracleDay(n2), this.oracleTime(n2), timeZone));
            if (s == 11) {
                timestamp.setNanos(this.oracleNanos(n2));
            }
        }
        return timestamp;
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = 11;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
        this.byteLength = this.t_max_length;
    }
}

