/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleConnectionCacheEventListener
implements ConnectionEventListener,
Serializable {
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    protected OracleImplicitConnectionCache m_oicc = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    public OracleConnectionCacheEventListener() {
        this(null);
    }

    public OracleConnectionCacheEventListener(OracleImplicitConnectionCache oracleImplicitConnectionCache) {
        this.m_oicc = oracleImplicitConnectionCache;
    }

    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            if (this.m_oicc != null) {
                this.m_oicc.reusePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {}
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            if (this.m_oicc != null) {
                this.m_oicc.closePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {}
    }
}

